/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.script.basic;

import org.alinous.AlinousCore;
import org.alinous.debug.StepInCandidates;
import org.alinous.exec.pages.PostContext;
import org.alinous.expections.AlinousException;
import org.alinous.expections.ExecutionException;
import org.alinous.script.IScriptSentence;
import org.alinous.script.basic.AbstractScriptBlock;
import org.alinous.script.basic.BreakSentence;
import org.alinous.script.basic.ContinueSentence;
import org.alinous.script.basic.DummyConditionSentence;
import org.alinous.script.basic.condition.IScriptCondition;
import org.alinous.script.basic.condition.JDomConditionFactory;
import org.alinous.script.runtime.VariableRepository;
import org.jdom.Content;
import org.jdom.Element;

public class WhileBlock
extends AbstractScriptBlock {
    public static final String BLOCK_NAME = "WhileBlock";
    private IScriptCondition condition;

    public String getName() {
        return BLOCK_NAME;
    }

    public boolean execute(PostContext context, VariableRepository valRepo) throws ExecutionException {
        boolean condResult = this.condition.evaluate(context, valRepo);
        if (!condResult) {
            return true;
        }
        while (condResult) {
            for (IScriptSentence exec : this.sentences) {
                boolean bl = this.executeSentence(exec, context, valRepo);
                if (!bl) {
                    return false;
                }
                if (exec instanceof BreakSentence) {
                    return true;
                }
                if (!(exec instanceof ContinueSentence)) continue;
                break;
            }
            if (AlinousCore.debug) {
                DummyConditionSentence dummyExec = new DummyConditionSentence(this);
                dummyExec.setCondition(this.condition);
                context.getCore().getAlinousDebugManager().aboutToExecuteSentence(this, dummyExec);
            }
            if (condResult = this.condition.evaluate(context, valRepo)) continue;
            return true;
        }
        return true;
    }

    public void exportIntoJDomElement(Element parent) throws AlinousException {
        Element selectElement = new Element("EXECUTABLE");
        selectElement.setAttribute("execClass", this.getClass().getName());
        parent.addContent((Content)selectElement);
        this.condition.exportIntoJDomElement(selectElement);
    }

    public void importFromJDomElement(Element element) throws AlinousException {
        Element cond = element.getChild("CONDITION");
        this.condition = JDomConditionFactory.createConditionFromJDomElement(cond);
        this.condition.importFromJDomElement(cond);
    }

    public IScriptCondition getCondition() {
        return this.condition;
    }

    public void setCondition(IScriptCondition condition) {
        this.condition = condition;
    }

    public StepInCandidates getStepInCandidates() {
        StepInCandidates candidates = new StepInCandidates();
        this.condition.canStepInStatements(candidates);
        return candidates;
    }
}

