/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.script.basic.condition;

import java.util.LinkedList;
import java.util.List;
import org.alinous.debug.StepInCandidates;
import org.alinous.exec.pages.PostContext;
import org.alinous.expections.AlinousException;
import org.alinous.expections.ExecutionException;
import org.alinous.script.IScriptSentence;
import org.alinous.script.basic.condition.IScriptCondition;
import org.alinous.script.basic.condition.IStatementCondition;
import org.alinous.script.basic.condition.JDomConditionFactory;
import org.alinous.script.runtime.VariableRepository;
import org.jdom.Content;
import org.jdom.Element;

public abstract class AbstractStmtCondition
implements IStatementCondition {
    protected List<IScriptCondition> conditions = new LinkedList<IScriptCondition>();
    protected IScriptSentence callerSentence;
    private int line;
    private int linePosition;

    public void addCondition(IScriptCondition condition) {
        condition.setCallerSentence(this.callerSentence);
        this.conditions.add(condition);
    }

    public boolean evaluate(PostContext context, VariableRepository valRepo) throws ExecutionException {
        throw new ExecutionException("This condition is not condition but a statement.");
    }

    public void exportIntoJDomElement(Element parent) throws AlinousException {
        Element andElement = new Element("CONDITION");
        andElement.setAttribute("condClass", this.getClass().getName());
        parent.addContent((Content)andElement);
        for (IScriptCondition cnd : this.conditions) {
            cnd.exportIntoJDomElement(andElement);
        }
    }

    public void importFromJDomElement(Element element) throws AlinousException {
        List list = element.getChildren("CONDITION");
        for (Element el : list) {
            IScriptCondition cnd = JDomConditionFactory.createConditionFromJDomElement(el);
            cnd.importFromJDomElement(el);
            this.addCondition(cnd);
        }
    }

    public void canStepInStatements(StepInCandidates candidates) {
        for (IScriptCondition cnd : this.conditions) {
            cnd.canStepInStatements(candidates);
        }
    }

    public void setCallerSentence(IScriptSentence callerSentence) {
        this.callerSentence = callerSentence;
        for (IScriptCondition cnd : this.conditions) {
            cnd.setCallerSentence(callerSentence);
        }
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public int getLinePosition() {
        return this.linePosition;
    }

    public void setLinePosition(int linePosition) {
        this.linePosition = linePosition;
    }
}

