/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.script.functions;

import java.util.Stack;
import org.alinous.AlinousCore;
import org.alinous.debug.DebugThread;
import org.alinous.debug.StepInCandidates;
import org.alinous.exec.pages.PostContext;
import org.alinous.expections.ExecutionException;
import org.alinous.script.IScriptSentence;
import org.alinous.script.basic.AbstractScriptBlock;
import org.alinous.script.basic.type.IStatement;
import org.alinous.script.basic.type.VariableDescriptor;
import org.alinous.script.functions.ArgumentDeclare;
import org.alinous.script.functions.ArgumentsDeclare;
import org.alinous.script.functions.IFunction;
import org.alinous.script.runtime.IScriptVariable;
import org.alinous.script.runtime.ScriptArray;
import org.alinous.script.runtime.ScriptDomVariable;
import org.alinous.script.runtime.VariableRepository;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionDeclaration
extends AbstractScriptBlock
implements IFunction {
    public static final String BLOCK_NAME = "FuntionDeclaration";
    private String returnType;
    private String packageName;
    private String funcName;
    private ArgumentsDeclare arguments;
    private IScriptSentence callerSentence;
    private Stack<IStatement> stmtStack;

    @Override
    public String getName() {
        if (this.packageName != null) {
            return this.packageName + "." + this.funcName;
        }
        return this.funcName;
    }

    @Override
    public boolean execute(PostContext context, VariableRepository valRepo) throws ExecutionException {
        VariableRepository newValRepo = new VariableRepository();
        this.handleArguments(context, valRepo, newValRepo);
        if (AlinousCore.debug) {
            DebugThread thread = context.getCore().getAlinousDebugManager().getCurrentThread();
            thread.getTopStackFrame().incCandidate();
        }
        if (AlinousCore.debug) {
            context.getCore().getAlinousDebugManager().createStackFrame(this, newValRepo);
        }
        for (IScriptSentence exec : this.sentences) {
            boolean bl = this.executeSentence(exec, context, newValRepo);
            if (bl) continue;
            if (AlinousCore.debug) {
                context.getCore().getAlinousDebugManager().destoryStackFrame();
            }
            this.handleArgumentChanged(context, valRepo, newValRepo);
            return false;
        }
        if (AlinousCore.debug) {
            context.getCore().getAlinousDebugManager().destoryStackFrame();
        }
        this.handleArgumentChanged(context, valRepo, newValRepo);
        return true;
    }

    private void handleArgumentChanged(PostContext context, VariableRepository valRepo, VariableRepository valRepoFunc) throws ExecutionException {
        if (this.arguments == null) {
            return;
        }
        int size = this.arguments.getSize();
        for (int i = 0; i < size; ++i) {
            ArgumentDeclare dec = this.arguments.get(i);
            IScriptVariable val = valRepoFunc.get(dec.getName());
            IStatement stmt = (IStatement)this.stmtStack.get(i);
            if (!(stmt instanceof VariableDescriptor)) continue;
            VariableDescriptor desc = (VariableDescriptor)stmt;
            valRepo.putValue(desc.getPath(), val, context);
        }
    }

    private void handleArguments(PostContext context, VariableRepository valRepoOld, VariableRepository valRepo) throws ExecutionException {
        if (this.stmtStack == null && this.arguments != null) {
            throw new ExecutionException("Number of the function is wrong.");
        }
        if (this.stmtStack != null && this.arguments == null) {
            throw new ExecutionException("Number of the function is wrong.");
        }
        if (this.stmtStack == null && this.arguments == null) {
            return;
        }
        if (this.stmtStack.size() != this.arguments.getSize()) {
            throw new ExecutionException("Number of the function is wrong.");
        }
        int size = this.arguments.getSize();
        for (int i = 0; i < size; ++i) {
            ArgumentDeclare dec;
            IStatement stmt = (IStatement)this.stmtStack.get(i);
            IScriptVariable val = stmt.executeStatement(context, valRepoOld);
            if (AlinousCore.debug) {
                context.getCore().getAlinousDebugManager().afterExecutedFunctionArgumentStatement(this.callerSentence);
            }
            if ((dec = this.arguments.get(i)).getPrefix().equals("$")) {
                if (!(val instanceof ScriptDomVariable)) {
                    throw new ExecutionException("Argument " + i + " must be DomVariable.");
                }
            } else if (dec.getPrefix().equals("@")) {
                if (val instanceof ScriptDomVariable && ((ScriptDomVariable)val).getValue() == null) {
                    val = new ScriptArray();
                } else if (!(val instanceof ScriptArray)) {
                    throw new ExecutionException("Argument " + i + " must be Array.");
                }
            } else {
                throw new ExecutionException("Argument " + i + " has no prefix.");
            }
            val.setName(dec.getName());
            valRepo.putValue(val);
        }
    }

    @Override
    public void exportIntoJDomElement(Element parent) {
    }

    @Override
    public void importFromJDomElement(Element threadElement) {
    }

    @Override
    public ArgumentsDeclare getArguments() {
        return this.arguments;
    }

    public void setArguments(ArgumentsDeclare arguments) {
        this.arguments = arguments;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getFuncName() {
        return this.funcName;
    }

    public void setFuncName(String funcName) {
        this.funcName = funcName;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    @Override
    public void inputArguments(Stack<IStatement> stmtStack) {
        this.stmtStack = stmtStack;
    }

    public void canStepInStatements(StepInCandidates candidates) {
        candidates.addCandidate(this);
    }

    public boolean canStepIn() {
        return true;
    }

    @Override
    public StepInCandidates getStepInCandidates() {
        return null;
    }

    @Override
    public void setCallerSentence(IScriptSentence callerSentence) {
        this.callerSentence = callerSentence;
    }

    @Override
    public IScriptVariable getResult() {
        return this.getReturnedVariable();
    }
}

