/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.script.functions;

import java.util.HashMap;
import java.util.Map;
import org.alinous.script.functions.FunctionDeclaration;
import org.alinous.script.functions.IFunction;
import org.alinous.script.functions.system.ArraySize;
import org.alinous.script.functions.system.CastToDouble;
import org.alinous.script.functions.system.CastToNumber;
import org.alinous.script.functions.system.MailSend;
import org.alinous.script.functions.system.StringReplace;
import org.alinous.script.functions.system.SystemPrint;
import org.alinous.script.functions.system.VariableRelease;

public class FunctionRegistory {
    private Map<String, IFunction> functions = new HashMap<String, IFunction>();
    public static FunctionRegistory instance;

    private FunctionRegistory() {
        this.registerFunction(new SystemPrint());
        this.registerFunction(new ArraySize());
        this.registerFunction(new CastToNumber());
        this.registerFunction(new CastToDouble());
        this.registerFunction(new MailSend());
        this.registerFunction(new VariableRelease());
        this.registerFunction(new StringReplace());
    }

    private void registerFunction(IFunction func) {
        this.functions.put(func.getName().toUpperCase(), func);
    }

    public static FunctionRegistory getInstance() {
        if (instance == null) {
            instance = new FunctionRegistory();
        }
        return instance;
    }

    public void registerFunction(FunctionDeclaration declare) {
        this.functions.put(declare.getName(), declare);
    }

    public IFunction findDeclaration(String qualifiedName) {
        return this.functions.get(qualifiedName.toUpperCase());
    }
}

