/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.script.functions.system;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.alinous.exec.pages.PostContext;
import org.alinous.expections.ExecutionException;
import org.alinous.jdk.model.ArgumentModel;
import org.alinous.jdk.model.FunctionModel;
import org.alinous.script.functions.ArgumentDeclare;
import org.alinous.script.functions.system.AbstractSystemFunction;
import org.alinous.script.runtime.IPathElement;
import org.alinous.script.runtime.IScriptVariable;
import org.alinous.script.runtime.PathElementFactory;
import org.alinous.script.runtime.VariableRepository;

public class JavaConnectorFunction
extends AbstractSystemFunction {
    private FunctionModel funcModel;
    private String name;
    private IScriptVariable retVal;

    public JavaConnectorFunction(String name, FunctionModel funcModel) {
        this.name = name;
        this.funcModel = funcModel;
        for (ArgumentModel argModel : this.funcModel.getArguments()) {
            ArgumentDeclare arg;
            if (argModel.getClazz().isArray()) {
                arg = new ArgumentDeclare("@", this.argName(argModel.getIndex()));
                this.argmentsDeclare.addArgument(arg);
                continue;
            }
            arg = new ArgumentDeclare("$", this.argName(argModel.getIndex()));
            this.argmentsDeclare.addArgument(arg);
        }
    }

    private String argName(int index) {
        return "arg" + Integer.toString(index);
    }

    public boolean execute(PostContext context, VariableRepository valRepo) throws ExecutionException {
        VariableRepository newValRepo = new VariableRepository();
        this.handleArguments(context, valRepo, newValRepo);
        ArrayList<IScriptVariable> runtimeArg = new ArrayList<IScriptVariable>();
        for (ArgumentModel argModel : this.funcModel.getArguments()) {
            IScriptVariable argVal = this.getVariable(context, newValRepo, this.argName(argModel.getIndex()));
            runtimeArg.add(argVal);
        }
        try {
            this.retVal = this.funcModel.invoke(runtimeArg.toArray(new IScriptVariable[runtimeArg.size()]));
        }
        catch (SecurityException e) {
            throw new ExecutionException(e, "Failed to invoke Native method.");
        }
        catch (IllegalArgumentException e) {
            throw new ExecutionException(e, "Failed to invoke Native method.");
        }
        catch (InstantiationException e) {
            throw new ExecutionException(e, "Failed to invoke Native method.");
        }
        catch (IllegalAccessException e) {
            throw new ExecutionException(e, "Failed to invoke Native method.");
        }
        catch (NoSuchMethodException e) {
            throw new ExecutionException(e, "Failed to invoke Native method.");
        }
        catch (InvocationTargetException e) {
            throw new ExecutionException(e, "Failed to invoke Native method.");
        }
        catch (Throwable e) {
            throw new ExecutionException(e, "Failed to invoke Native method.");
        }
        return true;
    }

    private IScriptVariable getVariable(PostContext context, VariableRepository valRepo, String name) throws ExecutionException {
        IPathElement ipath = PathElementFactory.buildPathElement(name);
        IScriptVariable val = valRepo.getVariable(ipath, context);
        return val;
    }

    public String getName() {
        return this.name;
    }

    public IScriptVariable getResult() {
        return this.retVal;
    }
}

