/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.script.sql.condition;

import org.alinous.expections.ExecutionException;
import org.alinous.script.runtime.VariableRepository;
import org.alinous.script.sql.adjustopt.AdjustSet;
import org.alinous.script.sql.adjustopt.AdjustWhere;
import org.alinous.script.sql.condition.ISQLExpression;
import org.alinous.script.sql.statement.ISQLStatement;

public class LikeExpression
implements ISQLExpression {
    private ISQLStatement left;
    private ISQLStatement right;
    private ISQLStatement escape;
    private VariableRepository valueProvidor;

    public boolean isReady() throws ExecutionException {
        return this.left.isReady() && this.right.isReady();
    }

    public void acceptVariables(VariableRepository providor, AdjustWhere adjustWhere, AdjustSet adjustSet) {
        this.valueProvidor = providor;
        if (this.left != null) {
            this.left.acceptVariables(this.valueProvidor, adjustWhere, adjustSet);
        }
        if (this.right != null) {
            this.right.acceptVariables(this.valueProvidor, adjustWhere, adjustSet);
        }
        if (this.escape != null) {
            this.escape.acceptVariables(this.valueProvidor, adjustWhere, adjustSet);
        }
    }

    public String extract() throws ExecutionException {
        StringBuffer buff = new StringBuffer();
        buff.append(this.left.extract());
        buff.append(" LIKE ");
        buff.append(this.right.extract());
        if (this.escape != null) {
            buff.append("  ESCAPE ");
            buff.append(this.escape.extract());
        }
        return buff.toString();
    }

    public ISQLStatement getLeft() {
        return this.left;
    }

    public void setLeft(ISQLStatement left) {
        this.left = left;
    }

    public ISQLStatement getRight() {
        return this.right;
    }

    public void setRight(ISQLStatement right) {
        this.right = right;
    }

    public ISQLStatement getEscape() {
        return this.escape;
    }

    public void setEscape(ISQLStatement escape) {
        this.escape = escape;
    }
}

