/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.script.statement;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.alinous.debug.StepInCandidates;
import org.alinous.exec.pages.PostContext;
import org.alinous.expections.AlinousException;
import org.alinous.expections.AlinousNullPointerException;
import org.alinous.expections.ExecutionException;
import org.alinous.script.IScriptSentence;
import org.alinous.script.basic.type.IStatement;
import org.alinous.script.basic.type.StatementJDomFactory;
import org.alinous.script.runtime.IScriptVariable;
import org.alinous.script.runtime.ScriptDomVariable;
import org.alinous.script.runtime.VariableRepository;
import org.alinous.script.statement.OperationValuePair;
import org.alinous.script.statement.SubStatement;
import org.jdom.Content;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlusStatement
implements IStatement {
    public static final int OPERATION_INT = 1;
    public static final int OPERATION_DOUBLE = 2;
    public static final int OPERATION_STRING = 3;
    private IStatement first;
    private List<IStatement> opeStatements = new LinkedList<IStatement>();
    private IScriptSentence callerSentence;

    public void addOperation(IStatement ope) {
        ope.setCallerSentence(this.callerSentence);
        this.opeStatements.add(ope);
    }

    public IStatement getFirst() {
        return this.first;
    }

    public void setFirst(IStatement first) {
        first.setCallerSentence(this.callerSentence);
        this.first = first;
    }

    @Override
    public IScriptVariable executeStatement(PostContext context, VariableRepository valRepo) throws ExecutionException {
        IScriptVariable firstValueble = this.first.executeStatement(context, valRepo);
        if (!(firstValueble instanceof ScriptDomVariable)) {
            throw new ExecutionException("Cannot multiple/divide array.");
        }
        ArrayList<OperationValuePair> valuesList = new ArrayList<OperationValuePair>();
        for (SubStatement subStatement : this.opeStatements) {
            IScriptVariable val = subStatement.executeStatement(context, valRepo);
            if (!(val instanceof ScriptDomVariable)) {
                throw new ExecutionException("Cannot multiple/divide array.");
            }
            valuesList.add(new OperationValuePair(subStatement.getOpe(), (ScriptDomVariable)val));
        }
        int n = this.getOperationType(valuesList, (ScriptDomVariable)firstValueble);
        IScriptVariable scVal = this.executePlus(valuesList, (ScriptDomVariable)firstValueble, n);
        return scVal;
    }

    private IScriptVariable executePlus(List<OperationValuePair> valuesList, ScriptDomVariable firstValueble, int operationType) {
        IScriptVariable scVal = null;
        switch (operationType) {
            case 1: {
                scVal = this.executePlusInt(valuesList, firstValueble, operationType);
                break;
            }
            case 2: {
                scVal = this.executePlusDouble(valuesList, firstValueble, operationType);
                break;
            }
            default: {
                scVal = this.executePlusString(valuesList, firstValueble, operationType);
            }
        }
        return scVal;
    }

    private IScriptVariable executePlusString(List<OperationValuePair> valuesList, ScriptDomVariable firstValueble, int operationType) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(firstValueble.getValue());
        for (OperationValuePair val : valuesList) {
            buffer.append(val.getValue().getValue());
        }
        ScriptDomVariable retVal = new ScriptDomVariable("");
        retVal.setValue(buffer.toString());
        retVal.setValueType("STRING");
        return retVal;
    }

    private IScriptVariable executePlusInt(List<OperationValuePair> valuesList, ScriptDomVariable firstValueble, int operationType) {
        int retInt = Integer.parseInt(firstValueble.getValue());
        for (OperationValuePair val : valuesList) {
            if (val.getOperation().equals("+")) {
                retInt += Integer.parseInt(val.getValue().getValue());
                continue;
            }
            retInt -= Integer.parseInt(val.getValue().getValue());
        }
        ScriptDomVariable retVal = new ScriptDomVariable("");
        retVal.setValue(Integer.toString(retInt));
        retVal.setValueType("NUMBER");
        return retVal;
    }

    private IScriptVariable executePlusDouble(List<OperationValuePair> valuesList, ScriptDomVariable firstValueble, int operationType) {
        double retDouble = Double.parseDouble(firstValueble.getValue());
        for (OperationValuePair val : valuesList) {
            if (val.getOperation().equals("+")) {
                retDouble += Double.parseDouble(val.getValue().getValue());
                continue;
            }
            retDouble -= Double.parseDouble(val.getValue().getValue());
        }
        ScriptDomVariable retVal = new ScriptDomVariable("");
        retVal.setValue(Double.toString(retDouble));
        retVal.setValueType("DOUBLE");
        return retVal;
    }

    private int getOperationType(List<OperationValuePair> valuesList, ScriptDomVariable firstValueble) throws AlinousNullPointerException {
        int ope = 1;
        if (firstValueble.getValueType().equals("NULL")) {
            throw new AlinousNullPointerException("");
        }
        if (firstValueble.getValueType().equals("NUMBER")) {
            ope = 1;
        } else if (firstValueble.getValueType().equals("DOUBLE")) {
            ope = 2;
        } else {
            return 3;
        }
        Iterator<OperationValuePair> it = valuesList.iterator();
        while (it.hasNext()) {
            ScriptDomVariable val = it.next().getValue();
            if (val.getValueType().equals("NULL")) {
                throw new AlinousNullPointerException("");
            }
            if (val.getValueType().equals("NUMBER")) continue;
            if (val.getValueType().equals("DOUBLE")) {
                ope = 2;
                continue;
            }
            if (val.getValueType().equals("BOOLEAN")) {
                return 3;
            }
            if (!val.getValueType().equals("STRING")) continue;
            return 3;
        }
        return ope;
    }

    @Override
    public void exportIntoJDomElement(Element parent) throws AlinousException {
        Element element = new Element("STATEMENT");
        element.setAttribute("className", this.getClass().getName());
        parent.addContent((Content)element);
        this.first.exportIntoJDomElement(element);
        for (IStatement stmt : this.opeStatements) {
            stmt.exportIntoJDomElement(element);
        }
    }

    @Override
    public void importFromJDomElement(Element element) throws AlinousException {
        boolean first = true;
        for (Element el : element.getChildren("STATEMENT")) {
            IStatement stmt = StatementJDomFactory.createStatementFromDom(el);
            stmt.importFromJDomElement(el);
            if (first) {
                first = false;
                this.first = stmt;
                continue;
            }
            this.opeStatements.add(stmt);
        }
    }

    @Override
    public void canStepInStatements(StepInCandidates candidates) {
        this.first.canStepInStatements(candidates);
        for (IStatement stmt : this.opeStatements) {
            stmt.canStepInStatements(candidates);
        }
    }

    @Override
    public void setCallerSentence(IScriptSentence callerSentence) {
        this.callerSentence = callerSentence;
        this.first.setCallerSentence(callerSentence);
        for (IStatement stmt : this.opeStatements) {
            stmt.setCallerSentence(callerSentence);
        }
    }
}

