/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.datasrc.types;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import org.alinous.datasrc.types.DataField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataTable {
    private Hashtable<String, DataField> fields = new Hashtable();
    private String name;

    public DataTable() {
    }

    public DataTable(String tblName) {
        this.name = tblName;
    }

    public int getNumFields() {
        return this.fields.size();
    }

    public List<String> getFields() {
        LinkedList<String> list = new LinkedList<String>();
        Enumeration<String> keys = this.fields.keys();
        while (keys.hasMoreElements()) {
            String f = keys.nextElement();
            list.add(f);
        }
        return list;
    }

    public DataField getDataField(String fldName) {
        return this.fields.get(fldName);
    }

    public void addField(DataField field) {
        this.fields.put(field.getName(), field);
    }

    public void addField(String fldName, String fldType) {
        DataField fld = new DataField(fldName, fldType);
        fld.setPrimary(false);
        this.addField(fld);
    }

    public void addField(String fldName, String fldType, boolean primary, int keyLength) {
        DataField fld = new DataField(fldName, fldType);
        fld.setPrimary(primary);
        fld.setKeyLength(keyLength);
        this.addField(fld);
    }

    public void addField(String fldName, String fldType, boolean primary) {
        DataField fld = new DataField(fldName, fldType);
        fld.setPrimary(primary);
        fld.setKeyLength(-1);
        this.addField(fld);
    }

    public void addField(String fldName, String fldType, boolean primary, boolean index) {
        DataField fld = new DataField(fldName, fldType);
        fld.setPrimary(primary);
        fld.setIndex(index);
        this.addField(fld);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

