/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.debug;

import org.alinous.AlinousUtils;
import org.alinous.debug.DebugThread;
import org.alinous.exec.IExecutable;

public class AlinousDebugEvent {
    public static final int STARTED = 0;
    public static final int BEFORE_SENTENCE = 1;
    public static final int BEFORE_STATEMENT = 2;
    public static final int BEFORE_CREATE_STACKFRAME = 3;
    public static final int AFTER_CALLED_ARGUMENT = 4;
    private int eventType;
    private int line;
    private String filePath;
    private DebugThread thread;
    private IExecutable sentence;

    public AlinousDebugEvent(int eventType, int line, String filePath, DebugThread thread) {
        this.eventType = eventType;
        this.line = line;
        this.filePath = AlinousUtils.forceUnixPath(filePath);
        this.thread = thread;
    }

    public int getEventType() {
        return this.eventType;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public int getLine() {
        return this.line;
    }

    public IExecutable getSentence() {
        return this.sentence;
    }

    public void setSentence(IExecutable sentence) {
        this.sentence = sentence;
    }

    public DebugThread getThread() {
        return this.thread;
    }

    public String toString() {
        String strEvent = "UNKNOWN";
        switch (this.eventType) {
            case 0: {
                strEvent = "STARTED";
                break;
            }
            case 1: {
                strEvent = "BEFORE_SENTENCE";
                break;
            }
            case 2: {
                strEvent = "BEFORE_STATEMENT";
                break;
            }
            case 3: {
                strEvent = "BEFORE_CREATE_STACKFRAME";
                break;
            }
            case 4: {
                strEvent = "AFTER_CALLED_ARGUMENT";
                break;
            }
        }
        return "{eventType : " + strEvent + " line : " + this.line + " filePath : " + this.filePath + "}";
    }
}

