/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.objects.html;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import org.alinous.exec.InnerModulePath;
import org.alinous.exec.pages.PostContext;
import org.alinous.expections.AlinousException;
import org.alinous.objects.Attribute;
import org.alinous.objects.IAlinousObject;
import org.alinous.objects.XMLTagBase;
import org.alinous.objects.html.AlinousTopObject;
import org.alinous.objects.html.IHtmlObject;

public class ButtonTagObject
extends XMLTagBase
implements IHtmlObject {
    public static final String ATTR_ACTION = "action";

    public IAlinousObject fork() throws AlinousException {
        ButtonTagObject newObj = new ButtonTagObject();
        this.copyAttribute(this, newObj);
        this.forkInnerObjects(newObj);
        return newObj;
    }

    public void renderContents(PostContext context, Writer wr, int n) throws IOException, AlinousException {
        if (!this.handleIf(context)) {
            return;
        }
        if (this.handleBack(context, wr, n)) {
            return;
        }
        wr.append("<BUTTON");
        this.renderAttributes(wr, 0, true, true);
        wr.append(">");
        this.renderInnerContents(context, wr, n + 1);
        wr.append("</BUTTON>");
    }

    private boolean handleBack(PostContext context, Writer wr, int n) throws IOException, AlinousException {
        Attribute backAttr = (Attribute)this.alinousAttributes.get("alns:back");
        if (backAttr == null || !backAttr.getValue().getValue().toLowerCase().equals("true")) {
            return false;
        }
        String lastAction = context.getUnit().getBackingStatusCache().getLastPath(this.getTopObject().getModulePath(), this.getTopObject().getPath());
        String action = null;
        if (context.isInner()) {
            action = this.getTopObject().getTopTopObject().getPath();
        } else if (lastAction != null) {
            action = lastAction;
        } else {
            lastAction = action = context.getFormLastAction();
        }
        wr.append("<FORM ");
        wr.append("action=\"");
        wr.append(context.getFilePath(action));
        wr.append("\"");
        wr.append(" method=\"POST\">\n");
        wr.append("<INPUT type=\"submit\" name=\"back\" value=\"");
        if (!this.innserObj.isEmpty()) {
            XMLTagBase base = (XMLTagBase)this.innserObj.get(0);
            base.renderContents(context, wr, n);
        }
        wr.append("\">");
        ArrayList<XMLTagBase.FormHiddenValue> hiddens = new ArrayList<XMLTagBase.FormHiddenValue>();
        AlinousTopObject topObj = this.getTopObject();
        InnerModulePath modulePath = topObj.getModulePath();
        XMLTagBase.FormHiddenValue hidden = new XMLTagBase.FormHiddenValue("alns:formTargetTagId", modulePath.getStringPath());
        hiddens.add(hidden);
        hidden = new XMLTagBase.FormHiddenValue("alns:formAction", lastAction);
        hiddens.add(hidden);
        hidden = new XMLTagBase.FormHiddenValue("alns:back", "true");
        hiddens.add(hidden);
        this.renderHiddens(context, wr, n, hiddens);
        wr.append("</FORM>\n");
        return true;
    }

    public String getTagName() {
        return "BUTTON";
    }
}

