/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.script.functions.system;

import org.alinous.exec.pages.PostContext;
import org.alinous.expections.ExecutionException;
import org.alinous.script.functions.ArgumentDeclare;
import org.alinous.script.functions.system.AbstractSystemFunction;
import org.alinous.script.runtime.IPathElement;
import org.alinous.script.runtime.IScriptVariable;
import org.alinous.script.runtime.PathElementFactory;
import org.alinous.script.runtime.ScriptDomVariable;
import org.alinous.script.runtime.VariableRepository;

public class CastToDouble
extends AbstractSystemFunction {
    public static String QUALIFIED_NAME = "CAST.TODOUBLE";
    public static String ARRAY_ARG = "arg0";
    private IScriptVariable retVal;

    public CastToDouble() {
        ArgumentDeclare arg = new ArgumentDeclare("$", ARRAY_ARG);
        this.argmentsDeclare.addArgument(arg);
    }

    public boolean execute(PostContext context, VariableRepository valRepo) throws ExecutionException {
        VariableRepository newValRepo = new VariableRepository();
        this.handleArguments(context, valRepo, newValRepo);
        IPathElement ipath = PathElementFactory.buildPathElement(ARRAY_ARG);
        IScriptVariable val = newValRepo.getVariable(ipath, context);
        if (!(val instanceof ScriptDomVariable)) {
            throw new ExecutionException(QUALIFIED_NAME + "() argument is wrong.");
        }
        ScriptDomVariable domValue = (ScriptDomVariable)val;
        try {
            Double.parseDouble(domValue.getValue());
        }
        catch (Throwable e) {
            throw new ExecutionException(e, "Format error.");
        }
        domValue.setValueType("DOUBLE");
        this.retVal = domValue;
        return true;
    }

    public String getName() {
        return QUALIFIED_NAME;
    }

    public IScriptVariable getResult() {
        return this.retVal;
    }
}

