/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.security;

import java.util.ArrayList;
import java.util.List;
import org.alinous.security.Zone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityConfig {
    private String relmDataSource;
    private String relmTable;
    private String relmUsers;
    private String relmPasswords;
    private String relmRoles;
    private List<Zone> zones = new ArrayList<Zone>();
    private List<String> exceptionalPages = new ArrayList<String>();

    public void addZone(Zone zn) {
        this.zones.add(zn);
        if (zn.getErrorPage() != null) {
            this.exceptionalPages.add(zn.getErrorPage().toLowerCase());
        }
        if (zn.getLoginForm() != null) {
            this.exceptionalPages.add(zn.getLoginForm().toLowerCase());
        }
        if (zn.getConfirmForm() != null) {
            this.exceptionalPages.add(zn.getConfirmForm().toLowerCase());
        }
    }

    public boolean isExceptionalPage(String path) {
        return this.exceptionalPages.contains(path.toLowerCase());
    }

    public String getRelmDataSource() {
        return this.relmDataSource;
    }

    public void setRelmDataSource(String relmDataSource) {
        this.relmDataSource = relmDataSource;
    }

    public String getRelmPasswords() {
        return this.relmPasswords;
    }

    public void setRelmPasswords(String relmPasswords) {
        this.relmPasswords = relmPasswords;
    }

    public String getRelmRoles() {
        return this.relmRoles;
    }

    public void setRelmRoles(String relmRoles) {
        this.relmRoles = relmRoles;
    }

    public String getRelmTable() {
        return this.relmTable;
    }

    public void setRelmTable(String relmTable) {
        this.relmTable = relmTable;
    }

    public String getRelmUsers() {
        return this.relmUsers;
    }

    public void setRelmUsers(String relmUsers) {
        this.relmUsers = relmUsers;
    }

    public List<Zone> getZones() {
        return this.zones;
    }
}

