/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool.composite;

import java.io.Serializable;
import java.util.List;
import java.util.ListIterator;
import java.util.Timer;
import org.apache.commons.pool.composite.CompositeObjectPool;
import org.apache.commons.pool.composite.DelegateLender;
import org.apache.commons.pool.composite.Lender;

abstract class EvictorLender
extends DelegateLender
implements Serializable {
    private static final long serialVersionUID = 4040627184050939757L;
    private final boolean prune;

    protected EvictorLender(Lender delegate) throws IllegalArgumentException {
        super(delegate);
        this.prune = !(delegate instanceof EvictorLender);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object borrow() {
        EvictorReference ref = (EvictorReference)super.borrow();
        Object obj = null;
        if (ref != null) {
            EvictorReference evictorReference = ref;
            synchronized (evictorReference) {
                obj = ref.get();
                ref.clear();
            }
        }
        return obj;
    }

    public void repay(Object obj) {
        super.repay(this.createReference(obj));
    }

    public ListIterator listIterator() {
        return new EvictorListIterator(super.listIterator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        if (this.prune) {
            List list = this.getObjectPool().getPool();
            synchronized (list) {
                ListIterator iter = super.listIterator();
                while (iter.hasNext()) {
                    Object o = iter.next();
                    while (o instanceof Lender.LenderReference) {
                        o = ((Lender.LenderReference)o).get();
                    }
                    if (o != null) continue;
                    iter.remove();
                }
            }
        }
        return super.size();
    }

    protected abstract EvictorReference createReference(Object var1);

    protected final Timer getTimer() {
        return CompositeObjectPool.COMPOSITE_TIMER;
    }

    private static class EvictorListIterator
    implements ListIterator {
        private final ListIterator iter;

        private EvictorListIterator(ListIterator iter) {
            this.iter = iter;
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Object next() {
            EvictorReference ref = (EvictorReference)this.iter.next();
            return ref != null ? ref.get() : null;
        }

        public boolean hasPrevious() {
            return this.iter.hasPrevious();
        }

        public Object previous() {
            EvictorReference ref = (EvictorReference)this.iter.previous();
            return ref != null ? ref.get() : null;
        }

        public int nextIndex() {
            return this.iter.nextIndex();
        }

        public int previousIndex() {
            return this.iter.previousIndex();
        }

        public void remove() {
            this.iter.remove();
        }

        public void set(Object o) {
            this.iter.set(o);
        }

        public void add(Object o) {
            this.iter.add(o);
        }
    }

    protected static interface EvictorReference
    extends Lender.LenderReference {
        public Object get();

        public void clear();
    }
}

