/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Hashtable;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.DateTime;
import org.apache.derby.client.am.Decimal;
import org.apache.derby.client.am.DisconnectException;
import org.apache.derby.client.am.FloatingPoint;
import org.apache.derby.client.am.SignedBinary;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.Utils;
import org.apache.derby.client.net.CcsidManager;
import org.apache.derby.client.net.EncodedInputStream;
import org.apache.derby.client.net.NetAgent;
import org.apache.derby.client.net.NetLogWriter;

public class Request {
    protected byte[] bytes_;
    protected int offset_;
    private static final int MAX_MARKS_NESTING = 10;
    private int[] markStack_ = new int[10];
    private int top_ = 0;
    protected CcsidManager ccsidManager_;
    private int dssLengthLocation_ = 0;
    private int correlationID_ = 0;
    private boolean simpleDssFinalize = false;
    protected boolean passwordIncluded_ = false;
    protected int passwordStart_ = 0;
    protected int passwordLength_ = 0;
    protected NetAgent netAgent_;

    Request(NetAgent netAgent, int n, CcsidManager ccsidManager) {
        this.netAgent_ = netAgent;
        this.bytes_ = new byte[n];
        this.ccsidManager_ = ccsidManager;
        this.clearBuffer();
    }

    Request(NetAgent netAgent, CcsidManager ccsidManager, int n) {
        this(netAgent, n, ccsidManager);
    }

    protected final void clearBuffer() {
        this.offset_ = 0;
        this.top_ = 0;
        for (int i = 0; i < this.markStack_.length && this.markStack_[i] != 0; ++i) {
            this.markStack_[i] = 0;
        }
        this.dssLengthLocation_ = 0;
    }

    final void initialize() {
        this.clearBuffer();
        this.correlationID_ = 0;
    }

    final void setCcsidMgr(CcsidManager ccsidManager) {
        this.ccsidManager_ = ccsidManager;
    }

    protected final void ensureLength(int n) {
        if (n > this.bytes_.length) {
            byte[] byArray = new byte[Math.max(this.bytes_.length << 1, n)];
            System.arraycopy(this.bytes_, 0, byArray, 0, this.offset_);
            this.bytes_ = byArray;
        }
    }

    protected final void createCommand() {
        this.buildDss(false, false, false, 1, ++this.correlationID_, false);
    }

    protected void createXACommand() {
        this.buildDss(false, false, false, 5, ++this.correlationID_, false);
    }

    final void createCommandData() {
        this.buildDss(true, false, false, 3, this.correlationID_, false);
    }

    final void createEncryptedCommandData() {
        if (this.netAgent_.netConnection_.getSecurityMechanism() == 12 || this.netAgent_.netConnection_.getSecurityMechanism() == 13) {
            this.buildDss(true, false, false, 4, this.correlationID_, false);
        } else {
            this.buildDss(true, false, false, 3, this.correlationID_, false);
        }
    }

    private final void buildDss(boolean bl, boolean bl2, boolean bl3, int n, int n2, boolean bl4) {
        if (this.doesRequestContainData()) {
            if (this.simpleDssFinalize) {
                this.finalizeDssLength();
            } else {
                this.finalizePreviousChainedDss(bl);
            }
        }
        this.ensureLength(this.offset_ + 6);
        this.dssLengthLocation_ = this.offset_;
        this.bytes_[this.offset_++] = -1;
        this.bytes_[this.offset_++] = -1;
        this.bytes_[this.offset_++] = -48;
        if (bl2) {
            n |= 0x40;
            if (bl3) {
                n |= 0x10;
            }
        }
        this.bytes_[this.offset_++] = (byte)(n & 0xFF);
        this.bytes_[this.offset_++] = (byte)(n2 >>> 8 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(n2 & 0xFF);
        this.simpleDssFinalize = bl4;
    }

    final void writeScalarStream(boolean bl, boolean bl2, int n, int n2, InputStream inputStream, boolean bl3, int n3) throws DisconnectException, SqlException {
        if (this.netAgent_.netConnection_.getSecurityMechanism() == 12 || this.netAgent_.netConnection_.getSecurityMechanism() == 13) {
            this.writeEncryptedScalarStream(bl, bl2, n, n2, inputStream, bl3, n3);
        } else {
            this.writePlainScalarStream(bl, bl2, n, n2, inputStream, bl3, n3);
        }
    }

    final void writeEncryptedScalarStream(boolean bl, boolean bl2, int n, int n2, InputStream inputStream, boolean bl3, int n3) throws DisconnectException, SqlException {
        int n4 = n2;
        int n5 = this.prepScalarStream(bl, bl2, bl3, n4);
        int n6 = bl3 ? Utils.min(n4, 32756 - n5) : Utils.min(n4, 32757 - n5);
        byte[] byArray = this.buildLengthAndCodePointForEncryptedLob(n, n4, bl3, n5);
        byte[] byArray2 = new byte[n4];
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        do {
            try {
                n7 = inputStream.read(byArray2, n9, n4);
                n8 += n7;
            }
            catch (IOException iOException) {
                this.padScalarStreamForError(n4, n6);
                this.netAgent_.accumulateReadException(new SqlException(this.netAgent_.logWriter_, new ClientMessageId("XN014.S"), (Object)new Integer(n3), (Object)iOException.getMessage(), (Throwable)iOException));
                return;
            }
            if (n7 == -1) {
                this.netAgent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException((Agent)this.netAgent_, new ClientMessageId("58009.C.17"), (Object)new Integer(n3)));
                return;
            }
            n9 += n7;
        } while ((n4 -= n7) > 0);
        try {
            if (inputStream.read() != -1) {
                this.netAgent_.accumulateReadException(new SqlException(this.netAgent_.logWriter_, new ClientMessageId("XN015.S"), new Integer(n3)));
            }
        }
        catch (IOException iOException) {
            this.netAgent_.accumulateReadException(new SqlException(this.netAgent_.logWriter_, new ClientMessageId("XN016.S"), (Object)new Integer(n3), (Object)iOException.getMessage(), (Throwable)iOException));
        }
        byte[] byArray3 = new byte[byArray2.length + byArray.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        byte[] byArray4 = this.netAgent_.netConnection_.getEncryptionManager().encryptData(byArray3, 9, this.netAgent_.netConnection_.getTargetPublicKey(), this.netAgent_.netConnection_.getTargetPublicKey());
        int n10 = byArray4.length;
        int n11 = this.bytes_.length - this.offset_;
        if (n10 > this.bytes_.length - this.offset_) {
            System.arraycopy(byArray4, 0, this.bytes_, this.offset_, this.bytes_.length - this.offset_);
            this.offset_ = Short.MAX_VALUE;
            try {
                this.sendBytes(this.netAgent_.getOutputStream());
            }
            catch (IOException iOException) {
                this.netAgent_.throwCommunicationsFailure(iOException);
            }
        } else {
            System.arraycopy(byArray4, 0, this.bytes_, this.offset_, n10);
            this.offset_ += byArray4.length;
        }
        n10 -= n11;
        while (n10 > 0) {
            this.offset_ = 0;
            if (n10 - 32765 > 0) {
                this.bytes_[this.offset_++] = -1;
                this.bytes_[this.offset_++] = -1;
                System.arraycopy(byArray4, n11, this.bytes_, this.offset_, 32765);
                n10 -= 32765;
                n11 += 32765;
                this.offset_ = Short.MAX_VALUE;
                try {
                    this.sendBytes(this.netAgent_.getOutputStream());
                }
                catch (IOException iOException) {
                    this.netAgent_.throwCommunicationsFailure(iOException);
                }
                continue;
            }
            int n12 = n10 + 2;
            this.bytes_[this.offset_++] = (byte)(n12 >>> 8 & 0xFF);
            this.bytes_[this.offset_++] = (byte)(n12 & 0xFF);
            System.arraycopy(byArray4, n11, this.bytes_, this.offset_, n10);
            this.offset_ += n10;
            this.dssLengthLocation_ = this.offset_;
            n10 = 0;
        }
    }

    final void writePlainScalarStream(boolean bl, boolean bl2, int n, int n2, InputStream inputStream, boolean bl3, int n3) throws DisconnectException, SqlException {
        int n4 = n2;
        int n5 = this.prepScalarStream(bl, bl2, bl3, n4);
        int n6 = bl3 ? Utils.min(n4, 32756 - n5) : Utils.min(n4, 32757 - n5);
        this.buildLengthAndCodePointForLob(n, n4, bl3, n5);
        int n7 = 0;
        int n8 = 0;
        while (true) {
            try {
                n7 = inputStream.read(this.bytes_, this.offset_, n6);
                n8 += n7;
            }
            catch (IOException iOException) {
                this.padScalarStreamForError(n4, n6);
                this.netAgent_.accumulateReadException(new SqlException(this.netAgent_.logWriter_, new ClientMessageId("XN014.S"), (Object)new Integer(n3), (Object)iOException.getMessage(), (Throwable)iOException));
                return;
            }
            if (n7 == -1) {
                this.padScalarStreamForError(n4, n6);
                this.netAgent_.accumulateReadException(new SqlException(this.netAgent_.logWriter_, new ClientMessageId("XN017.S"), new Integer(n3)));
                return;
            }
            this.offset_ += n7;
            n4 -= n7;
            if ((n6 -= n7) > 0) continue;
            n6 = this.flushScalarStreamSegment(n4, n6);
            if (n4 <= 0) break;
        }
        try {
            if (inputStream.read() != -1) {
                this.netAgent_.accumulateReadException(new SqlException(this.netAgent_.logWriter_, new ClientMessageId("XN015.S"), new Integer(n3)));
            }
        }
        catch (IOException iOException) {
            this.netAgent_.accumulateReadException(new SqlException(this.netAgent_.logWriter_, new ClientMessageId("XN016.S"), (Object)new Integer(n3), (Object)iOException.getMessage(), (Throwable)iOException));
        }
    }

    final void writeScalarStream(boolean bl, boolean bl2, int n, int n2, Reader reader, boolean bl3, int n3) throws DisconnectException, SqlException {
        this.writeScalarStream(bl, bl2, n, n2 * 2, EncodedInputStream.createUTF16BEStream(reader), bl3, n3);
    }

    protected final int prepScalarStream(boolean bl, boolean bl2, boolean bl3, int n) throws DisconnectException {
        int n2;
        int n3 = 0;
        if (bl3) {
            n2 = this.calculateExtendedLengthByteCount((long)n + 4L + 1L);
            n3 = 1;
        } else {
            n2 = this.calculateExtendedLengthByteCount(n + 4);
        }
        if ((long)(10 + n2 + n3) + (long)n + (long)this.offset_ > 32767L) {
            try {
                if (this.simpleDssFinalize) {
                    this.finalizeDssLength();
                } else {
                    this.finalizePreviousChainedDss(true);
                }
                this.sendBytes(this.netAgent_.getOutputStream());
            }
            catch (IOException iOException) {
                this.netAgent_.throwCommunicationsFailure(iOException);
            }
        }
        if (this.netAgent_.netConnection_.getSecurityMechanism() == 12 || this.netAgent_.netConnection_.getSecurityMechanism() == 13) {
            this.buildDss(true, bl, bl2, 4, this.correlationID_, true);
        } else {
            this.buildDss(true, bl, bl2, 3, this.correlationID_, true);
        }
        return n2;
    }

    protected final int flushScalarStreamSegment(int n, int n2) throws DisconnectException {
        int n3 = n2;
        if (n != 0) {
            if (Utils.min(2 + n, Short.MAX_VALUE) > this.bytes_.length - this.offset_) {
                try {
                    this.sendBytes(this.netAgent_.getOutputStream());
                }
                catch (IOException iOException) {
                    this.netAgent_.throwCommunicationsFailure(iOException);
                }
            }
            this.dssLengthLocation_ = this.offset_;
            this.bytes_[this.offset_++] = -1;
            this.bytes_[this.offset_++] = -1;
            n3 = Utils.min(n, 32765);
        }
        return n3;
    }

    protected final void padScalarStreamForError(int n, int n2) throws DisconnectException {
        while (true) {
            this.bytes_[this.offset_++] = 0;
            --n;
            if (--n2 > 0) continue;
            n2 = this.flushScalarStreamSegment(n, n2);
            if (n <= 0) break;
        }
    }

    private final void writeExtendedLengthBytes(int n, long l) {
        int n2 = (n - 1) * 8;
        for (int i = 0; i < n; ++i) {
            this.bytes_[this.offset_++] = (byte)(l >>> n2 & 0xFFL);
            n2 -= 8;
        }
    }

    private final byte[] writeExtendedLengthBytesForEncryption(int n, long l) {
        int n2 = (n - 1) * 8;
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)(l >>> n2 & 0xFFL);
            n2 -= 8;
        }
        return byArray;
    }

    protected final void finalizePreviousChainedDss(boolean bl) {
        this.finalizeDssLength();
        int n = this.dssLengthLocation_ + 3;
        this.bytes_[n] = (byte)(this.bytes_[n] | 0x40);
        if (bl) {
            int n2 = this.dssLengthLocation_ + 3;
            this.bytes_[n2] = (byte)(this.bytes_[n2] | 0x10);
        }
    }

    protected final boolean doesRequestContainData() {
        return this.offset_ != 0;
    }

    protected final void finalizeDssLength() {
        int n = this.offset_ - this.dssLengthLocation_;
        int n2 = n - Short.MAX_VALUE;
        if (n2 > 0) {
            int n3;
            int n4 = n2 / 32765;
            if (n2 % 32765 != 0) {
                ++n4;
            }
            int n5 = this.offset_ - 1;
            int n6 = n4 * 2;
            this.ensureLength(this.offset_ + n6);
            this.offset_ += n6;
            boolean bl = true;
            do {
                if ((n3 = n2 % 32765) == 0) {
                    n3 = 32765;
                }
                System.arraycopy(this.bytes_, (n5 -= n3) + 1, this.bytes_, n5 + n6 + 1, n3);
                int n7 = n3 + 2;
                if (bl) {
                    bl = false;
                } else if (n7 == Short.MAX_VALUE) {
                    n7 = 65535;
                }
                this.bytes_[n5 + n6 - 1] = (byte)(n7 >>> 8 & 0xFF);
                this.bytes_[n5 + n6] = (byte)(n7 & 0xFF);
                n6 -= 2;
            } while ((n2 -= n3) > 0);
            n = 65535;
        }
        this.bytes_[this.dssLengthLocation_] = (byte)(n >>> 8 & 0xFF);
        this.bytes_[this.dssLengthLocation_ + 1] = (byte)(n & 0xFF);
    }

    protected final void markLengthBytes(int n) {
        this.ensureLength(this.offset_ + 4);
        this.mark();
        this.offset_ += 2;
        this.bytes_[this.offset_++] = (byte)(n >>> 8 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(n & 0xFF);
    }

    private final void mark() {
        this.markStack_[this.top_++] = this.offset_;
    }

    private final int popMark() {
        return this.markStack_[--this.top_];
    }

    protected final void markForCachingPKGNAMCSN() {
        this.mark();
    }

    protected final int popMarkForCachingPKGNAMCSN() {
        return this.popMark();
    }

    protected final void updateLengthBytes() throws SqlException {
        int n = this.popMark();
        int n2 = this.offset_ - n;
        int n3 = this.calculateExtendedLengthByteCount(n2);
        if (n3 != 0) {
            this.ensureLength(this.offset_ + n3);
            int n4 = n2 - 4;
            int n5 = n + 4;
            System.arraycopy(this.bytes_, n5, this.bytes_, n5 + n3, n4);
            int n6 = (n3 - 1) * 8;
            for (int i = 0; i < n3; ++i) {
                this.bytes_[n5++] = (byte)(n4 >>> n6 & 0xFF);
                n6 -= 8;
            }
            this.offset_ += n3;
            n2 = n3 + 4;
            n2 |= 0x8000;
        }
        this.bytes_[n] = (byte)(n2 >>> 8 & 0xFF);
        this.bytes_[n + 1] = (byte)(n2 & 0xFF);
    }

    private final int calculateExtendedLengthByteCount(long l) {
        if (l <= 32767L) {
            return 0;
        }
        if (l <= Integer.MAX_VALUE) {
            return 4;
        }
        if (l <= 0x7FFFFFFFFFFFL) {
            return 6;
        }
        return 8;
    }

    final void padBytes(byte by, int n) {
        this.ensureLength(this.offset_ + n);
        for (int i = 0; i < n; ++i) {
            this.bytes_[this.offset_++] = by;
        }
    }

    final void write1Byte(int n) {
        this.ensureLength(this.offset_ + 1);
        this.bytes_[this.offset_++] = (byte)(n & 0xFF);
    }

    final void buildTripletHeader(int n, int n2, int n3) {
        this.ensureLength(this.offset_ + 3);
        this.bytes_[this.offset_++] = (byte)(n & 0xFF);
        this.bytes_[this.offset_++] = (byte)(n2 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(n3 & 0xFF);
    }

    final void writeLidAndLengths(int[][] nArray, int n, int n2) {
        this.ensureLength(this.offset_ + n * 3);
        int n3 = 0;
        while (n3 < n) {
            this.bytes_[this.offset_++] = (byte)(nArray[n2][0] & 0xFF);
            this.bytes_[this.offset_++] = (byte)(nArray[n2][1] >>> 8 & 0xFF);
            this.bytes_[this.offset_++] = (byte)(nArray[n2][1] & 0xFF);
            ++n3;
            ++n2;
        }
    }

    final void writeLidAndLengths(int[][] nArray, int n, int n2, boolean bl, Hashtable hashtable) {
        if (!bl) {
            this.writeLidAndLengths(nArray, n, n2);
        } else {
            this.ensureLength(this.offset_ + n * 3);
            int n3 = 0;
            while (n3 < n) {
                int n4 = nArray[n2][0];
                Object v = hashtable.get(new Integer(n4));
                int n5 = v == null ? n4 : (Integer)v;
                this.bytes_[this.offset_++] = (byte)(n5 & 0xFF);
                this.bytes_[this.offset_++] = (byte)(nArray[n2][1] >>> 8 & 0xFF);
                this.bytes_[this.offset_++] = (byte)(nArray[n2][1] & 0xFF);
                ++n3;
                ++n2;
            }
        }
    }

    final void write2Bytes(int n) {
        this.ensureLength(this.offset_ + 2);
        this.bytes_[this.offset_++] = (byte)(n >>> 8 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(n & 0xFF);
    }

    final void write4Bytes(long l) {
        this.ensureLength(this.offset_ + 4);
        this.bytes_[this.offset_++] = (byte)(l >>> 24 & 0xFFL);
        this.bytes_[this.offset_++] = (byte)(l >>> 16 & 0xFFL);
        this.bytes_[this.offset_++] = (byte)(l >>> 8 & 0xFFL);
        this.bytes_[this.offset_++] = (byte)(l & 0xFFL);
    }

    final void writeBytes(byte[] byArray, int n) {
        this.ensureLength(this.offset_ + n);
        System.arraycopy(byArray, 0, this.bytes_, this.offset_, n);
        this.offset_ += n;
    }

    final void writeBytes(byte[] byArray) {
        this.ensureLength(this.offset_ + byArray.length);
        System.arraycopy(byArray, 0, this.bytes_, this.offset_, byArray.length);
        this.offset_ += byArray.length;
    }

    final void writeCodePoint4Bytes(int n, int n2) {
        this.ensureLength(this.offset_ + 4);
        this.bytes_[this.offset_++] = (byte)(n >>> 8 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(n & 0xFF);
        this.bytes_[this.offset_++] = (byte)(n2 >>> 8 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(n2 & 0xFF);
    }

    protected final void writeScalar1Byte(int n, int n2) {
        this.ensureLength(this.offset_ + 5);
        this.bytes_[this.offset_++] = 0;
        this.bytes_[this.offset_++] = 5;
        this.bytes_[this.offset_++] = (byte)(n >>> 8 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(n & 0xFF);
        this.bytes_[this.offset_++] = (byte)(n2 & 0xFF);
    }

    final void writeScalar2Bytes(int n, int n2) {
        this.ensureLength(this.offset_ + 6);
        this.bytes_[this.offset_++] = 0;
        this.bytes_[this.offset_++] = 6;
        this.bytes_[this.offset_++] = (byte)(n >>> 8 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(n & 0xFF);
        this.bytes_[this.offset_++] = (byte)(n2 >>> 8 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(n2 & 0xFF);
    }

    protected final void writeScalar4Bytes(int n, long l) {
        this.ensureLength(this.offset_ + 8);
        this.bytes_[this.offset_++] = 0;
        this.bytes_[this.offset_++] = 8;
        this.bytes_[this.offset_++] = (byte)(n >>> 8 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(n & 0xFF);
        this.bytes_[this.offset_++] = (byte)(l >>> 24 & 0xFFL);
        this.bytes_[this.offset_++] = (byte)(l >>> 16 & 0xFFL);
        this.bytes_[this.offset_++] = (byte)(l >>> 8 & 0xFFL);
        this.bytes_[this.offset_++] = (byte)(l & 0xFFL);
    }

    final void writeScalar8Bytes(int n, long l) {
        this.ensureLength(this.offset_ + 12);
        this.bytes_[this.offset_++] = 0;
        this.bytes_[this.offset_++] = 12;
        this.bytes_[this.offset_++] = (byte)(n >>> 8 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(n & 0xFF);
        this.bytes_[this.offset_++] = (byte)(l >>> 56 & 0xFFL);
        this.bytes_[this.offset_++] = (byte)(l >>> 48 & 0xFFL);
        this.bytes_[this.offset_++] = (byte)(l >>> 40 & 0xFFL);
        this.bytes_[this.offset_++] = (byte)(l >>> 32 & 0xFFL);
        this.bytes_[this.offset_++] = (byte)(l >>> 24 & 0xFFL);
        this.bytes_[this.offset_++] = (byte)(l >>> 16 & 0xFFL);
        this.bytes_[this.offset_++] = (byte)(l >>> 8 & 0xFFL);
        this.bytes_[this.offset_++] = (byte)(l & 0xFFL);
    }

    final void writeLengthCodePoint(int n, int n2) {
        this.ensureLength(this.offset_ + 4);
        this.bytes_[this.offset_++] = (byte)(n >>> 8 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(n & 0xFF);
        this.bytes_[this.offset_++] = (byte)(n2 >>> 8 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(n2 & 0xFF);
    }

    final byte[] writeEXTDTALengthCodePointForEncryption(int n, int n2) {
        byte[] byArray = new byte[]{(byte)(n >>> 8 & 0xFF), (byte)(n & 0xFF), (byte)(n2 >>> 8 & 0xFF), (byte)(n2 & 0xFF)};
        return byArray;
    }

    final void writeScalarBytes(int n, byte[] byArray, int n2) {
        this.ensureLength(this.offset_ + n2 + 4);
        this.bytes_[this.offset_++] = (byte)(n2 + 4 >>> 8 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(n2 + 4 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(n >>> 8 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(n & 0xFF);
        for (int i = 0; i < n2; ++i) {
            this.bytes_[this.offset_++] = byArray[i];
        }
    }

    final void writeScalarHeader(int n, int n2) {
        this.ensureLength(this.offset_ + n2 + 4);
        this.bytes_[this.offset_++] = (byte)(n2 + 4 >>> 8 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(n2 + 4 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(n >>> 8 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(n & 0xFF);
    }

    final void writeScalarString(int n, String string) throws SqlException {
        int n2 = string.length();
        this.ensureLength(this.offset_ + n2 + 4);
        this.bytes_[this.offset_++] = (byte)(n2 + 4 >>> 8 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(n2 + 4 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(n >>> 8 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(n & 0xFF);
        this.offset_ = this.ccsidManager_.convertFromUCS2(string, this.bytes_, this.offset_, this.netAgent_);
    }

    final void writeScalarPaddedString(int n, String string, int n2) throws SqlException {
        int n3 = string.length();
        this.ensureLength(this.offset_ + n2 + 4);
        this.bytes_[this.offset_++] = (byte)(n2 + 4 >>> 8 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(n2 + 4 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(n >>> 8 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(n & 0xFF);
        this.offset_ = this.ccsidManager_.convertFromUCS2(string, this.bytes_, this.offset_, this.netAgent_);
        for (int i = 0; i < n2 - n3; ++i) {
            this.bytes_[this.offset_++] = this.ccsidManager_.space_;
        }
    }

    final void writeScalarPaddedString(String string, int n) throws SqlException {
        int n2 = string.length();
        this.ensureLength(this.offset_ + n);
        this.offset_ = this.ccsidManager_.convertFromUCS2(string, this.bytes_, this.offset_, this.netAgent_);
        for (int i = 0; i < n - n2; ++i) {
            this.bytes_[this.offset_++] = this.ccsidManager_.space_;
        }
    }

    final void writeScalarBytes(int n, byte[] byArray) {
        int n2 = byArray.length;
        this.ensureLength(this.offset_ + n2 + 4);
        this.bytes_[this.offset_++] = (byte)(n2 + 4 >>> 8 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(n2 + 4 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(n >>> 8 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(n & 0xFF);
        System.arraycopy(byArray, 0, this.bytes_, this.offset_, n2);
        this.offset_ += n2;
    }

    final void writeScalarBytes(int n, byte[] byArray, int n2, int n3) {
        this.ensureLength(this.offset_ + n3 + 4);
        this.bytes_[this.offset_++] = (byte)(n3 + 4 >>> 8 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(n3 + 4 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(n >>> 8 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(n & 0xFF);
        System.arraycopy(byArray, n2, this.bytes_, this.offset_, n3);
        this.offset_ += n3;
    }

    final void writeScalarPaddedBytes(int n, byte[] byArray, int n2, byte by) {
        int n3 = byArray.length;
        this.ensureLength(this.offset_ + n2 + 4);
        this.bytes_[this.offset_++] = (byte)(n2 + 4 >>> 8 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(n2 + 4 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(n >>> 8 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(n & 0xFF);
        System.arraycopy(byArray, 0, this.bytes_, this.offset_, n3);
        this.offset_ += n3;
        for (int i = 0; i < n2 - n3; ++i) {
            this.bytes_[this.offset_++] = by;
        }
    }

    final void writeScalarPaddedBytes(byte[] byArray, int n, byte by) {
        int n2 = byArray.length;
        this.ensureLength(this.offset_ + n);
        System.arraycopy(byArray, 0, this.bytes_, this.offset_, n2);
        this.offset_ += n2;
        for (int i = 0; i < n - n2; ++i) {
            this.bytes_[this.offset_++] = by;
        }
    }

    protected void flush(OutputStream outputStream) throws IOException {
        if (this.doesRequestContainData()) {
            this.finalizeDssLength();
            this.sendBytes(outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendBytes(OutputStream outputStream) throws IOException {
        block5: {
            try {
                outputStream.write(this.bytes_, 0, this.offset_);
                outputStream.flush();
                Object var3_2 = null;
                if (this.netAgent_.logWriter_ == null || !this.passwordIncluded_) break block5;
                this.maskOutPassword();
                this.passwordIncluded_ = false;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (this.netAgent_.logWriter_ != null && this.passwordIncluded_) {
                    this.maskOutPassword();
                    this.passwordIncluded_ = false;
                }
                if (this.netAgent_.loggingEnabled()) {
                    ((NetLogWriter)this.netAgent_.logWriter_).traceProtocolFlow(this.bytes_, 0, this.offset_, 1, "Request", "flush", 1);
                }
                this.clearBuffer();
                throw throwable;
            }
        }
        if (this.netAgent_.loggingEnabled()) {
            ((NetLogWriter)this.netAgent_.logWriter_).traceProtocolFlow(this.bytes_, 0, this.offset_, 1, "Request", "flush", 1);
        }
        this.clearBuffer();
    }

    final void maskOutPassword() {
        try {
            String string = "*";
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.passwordLength_; ++i) {
                stringBuffer.append(string);
            }
            this.ccsidManager_.convertFromUCS2(stringBuffer.toString(), this.bytes_, this.passwordStart_, this.netAgent_);
        }
        catch (SqlException sqlException) {
            for (int i = 0; i < this.passwordLength_; ++i) {
                this.bytes_[this.passwordStart_ + i] = -1;
            }
        }
    }

    final void writeByte(byte by) {
        this.ensureLength(this.offset_ + 1);
        this.bytes_[this.offset_++] = by;
    }

    final void writeShort(short s) {
        this.ensureLength(this.offset_ + 2);
        SignedBinary.shortToBigEndianBytes(this.bytes_, this.offset_, s);
        this.offset_ += 2;
    }

    void writeInt(int n) {
        this.ensureLength(this.offset_ + 4);
        SignedBinary.intToBigEndianBytes(this.bytes_, this.offset_, n);
        this.offset_ += 4;
    }

    final void writeLong(long l) {
        this.ensureLength(this.offset_ + 8);
        SignedBinary.longToBigEndianBytes(this.bytes_, this.offset_, l);
        this.offset_ += 8;
    }

    protected void writeShortFdocaData(short s) {
        this.ensureLength(this.offset_ + 2);
        SignedBinary.shortToBigEndianBytes(this.bytes_, this.offset_, s);
        this.offset_ += 2;
    }

    protected void writeIntFdocaData(int n) {
        this.ensureLength(this.offset_ + 4);
        SignedBinary.intToBigEndianBytes(this.bytes_, this.offset_, n);
        this.offset_ += 4;
    }

    protected void writeLongFdocaData(long l) {
        this.ensureLength(this.offset_ + 8);
        SignedBinary.longToBigEndianBytes(this.bytes_, this.offset_, l);
        this.offset_ += 8;
    }

    protected void writeFloat(float f) {
        this.ensureLength(this.offset_ + 4);
        FloatingPoint.floatToIeee754Bytes(this.bytes_, this.offset_, f);
        this.offset_ += 4;
    }

    protected void writeDouble(double d) {
        this.ensureLength(this.offset_ + 8);
        FloatingPoint.doubleToIeee754Bytes(this.bytes_, this.offset_, d);
        this.offset_ += 8;
    }

    final void writeBigDecimal(BigDecimal bigDecimal, int n, int n2) throws SqlException {
        this.ensureLength(this.offset_ + 16);
        int n3 = Decimal.bigDecimalToPackedDecimalBytes(this.bytes_, this.offset_, bigDecimal, n, n2);
        this.offset_ += n3;
    }

    final void writeDate(Date date) throws SqlException {
        try {
            this.ensureLength(this.offset_ + 10);
            DateTime.dateToDateBytes(this.bytes_, this.offset_, date);
            this.offset_ += 10;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("22005.S.1"), (Object)"java.sql.Date", (Object)"DATE", (Throwable)unsupportedEncodingException);
        }
    }

    final void writeTime(Time time) throws SqlException {
        try {
            this.ensureLength(this.offset_ + 8);
            DateTime.timeToTimeBytes(this.bytes_, this.offset_, time);
            this.offset_ += 8;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("22005.S.1"), (Object)"java.sql.Time", (Object)"TIME", (Throwable)unsupportedEncodingException);
        }
    }

    final void writeTimestamp(Timestamp timestamp) throws SqlException {
        try {
            this.ensureLength(this.offset_ + 26);
            DateTime.timestampToTimestampBytes(this.bytes_, this.offset_, timestamp);
            this.offset_ += 26;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("22005.S.1"), (Object)"java.sql.Timestamp", (Object)"TIMESTAMP", (Throwable)unsupportedEncodingException);
        }
    }

    final void writeBoolean(boolean bl) {
        this.ensureLength(this.offset_ + 1);
        this.bytes_[this.offset_++] = (byte)((bl ? 1 : 0) & 0xFF);
    }

    final void writeSingleorMixedCcsidLDString(String string, String string2) throws SqlException {
        byte[] byArray;
        try {
            byArray = string.getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("22005.S.1"), (Object)"String", (Object)"byte", (Throwable)unsupportedEncodingException);
        }
        if (byArray.length > Short.MAX_VALUE) {
            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("22028"), "32767");
        }
        this.ensureLength(this.offset_ + byArray.length + 2);
        this.writeLDBytesX(byArray.length, byArray);
    }

    final void writeLDBytes(byte[] byArray) {
        this.ensureLength(this.offset_ + byArray.length + 2);
        this.writeLDBytesX(byArray.length, byArray);
    }

    private final void writeLDBytesX(int n, byte[] byArray) {
        this.bytes_[this.offset_++] = (byte)(n >>> 8 & 0xFF);
        this.bytes_[this.offset_++] = (byte)(n & 0xFF);
        System.arraycopy(byArray, 0, this.bytes_, this.offset_, byArray.length);
        this.offset_ += byArray.length;
    }

    final void writeDDMString(String string) throws SqlException {
        this.ensureLength(this.offset_ + string.length());
        this.offset_ = this.ccsidManager_.convertFromUCS2(string, this.bytes_, this.offset_, this.netAgent_);
    }

    private byte[] buildLengthAndCodePointForEncryptedLob(int n, int n2, boolean bl, int n3) throws DisconnectException {
        byte[] byArray;
        byte[] byArray2 = new byte[4];
        byte[] byArray3 = new byte[n3];
        if (n3 > 0) {
            byArray2 = this.writeEXTDTALengthCodePointForEncryption(32772 + n3, n);
            byArray3 = bl ? this.writeExtendedLengthBytesForEncryption(n3, n2 + 1) : this.writeExtendedLengthBytesForEncryption(n3, n2);
        } else {
            byArray2 = bl ? this.writeEXTDTALengthCodePointForEncryption(n2 + 4 + 1, n) : this.writeEXTDTALengthCodePointForEncryption(n2 + 4, n);
        }
        if (n3 > 0) {
            byArray = new byte[4 + byArray3.length];
            System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
            System.arraycopy(byArray3, 0, byArray, byArray2.length, byArray3.length);
            byArray2 = byArray;
        }
        if (bl) {
            byArray = new byte[1 + byArray2.length];
            System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
            byArray[byArray2.length] = 0;
            byArray2 = byArray;
        }
        return byArray2;
    }

    private void buildLengthAndCodePointForLob(int n, int n2, boolean bl, int n3) throws DisconnectException {
        if (n3 > 0) {
            this.writeLengthCodePoint(32772 + n3, n);
            if (bl) {
                this.writeExtendedLengthBytes(n3, n2 + 1);
            } else {
                this.writeExtendedLengthBytes(n3, n2);
            }
        } else if (bl) {
            this.writeLengthCodePoint(n2 + 4 + 1, n);
        } else {
            this.writeLengthCodePoint(n2 + 4, n);
        }
        if (bl) {
            this.write1Byte(0);
        }
    }

    public void setDssLengthLocation(int n) {
        this.dssLengthLocation_ = n;
    }

    public void setCorrelationID(int n) {
        this.correlationID_ = n;
    }
}

