/*
 * Decompiled with CFR 0.152.
 */
package org.alinous;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.alinous.AlinousUtils;
import org.alinous.datasrc.DataSourceConfig;
import org.alinous.datasrc.DataSourceConfigCollection;
import org.alinous.expections.AlinousException;
import org.alinous.expections.ConfigException;
import org.alinous.net.mail.AlinousMailConfig;
import org.alinous.repository.SystemRepositoryConfig;
import org.alinous.security.SecurityConfig;
import org.alinous.security.Zone;
import org.alinous.web.filter.FilterConfig;
import org.alinous.web.filter.FilterZone;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class AlinousConfig {
    public static final String ALINOUS_CONFIG = "alinous-config.xml";
    public static final String DATA_SOURCE_CONFIG = "datasources";
    public static final String SYSTEM = "system";
    public static final String SYSTEM_REPOSITORY = "system-datastore";
    public static final String DEFAULT_REPOSITORY = "default-datastore";
    public static final String NOT_FOUND_PAGE = "not-found-page";
    public static final String MAIL = "mail";
    public static final String SERVER = "server";
    public static final String PORT = "port";
    public static final String LANG_ENCODE = "lang-encode";
    public static final String AUTH = "auth";
    public static final String METHOD = "method";
    public static final String USER = "user";
    public static final String PASS = "pass";
    public static final String POP_AUTH = "pop-auth";
    public static final String BASIC_AUTH = "basic-auth";
    public static final String RELM = "relm";
    public static final String RELM_DATASRC = "datastore";
    public static final String RELM_TABLE = "table";
    public static final String RELM_USERS = "users";
    public static final String RELM_PASSWORDS = "passwords";
    public static final String RELM_ROLES = "roles";
    public static final String ZONES = "zones";
    public static final String ZONE = "zone";
    public static final String AREA = "area";
    public static final String ROLES = "roles";
    public static final String ERROR_PAGE = "error-page";
    public static final String FORM_AUTH = "form-auth";
    public static final String LOGIN_FORM = "login";
    public static final String CONFIRM_FORM = "confirm";
    public static final String FILTER = "filter";
    public static final String IN = "in";
    public static final String OUT = "out";
    private String alinousHome;
    private DataSourceConfigCollection dataSourceConfigs;
    private SystemRepositoryConfig systemRepositoryConfig;
    private AlinousMailConfig mailconfig;
    private SecurityConfig securityConfig;
    private FilterConfig filterConfig;

    public AlinousConfig(String alinousHome) throws AlinousException {
        File file = new File(alinousHome);
        this.alinousHome = file.getPath();
        if (this.alinousHome == null) {
            throw new AlinousException("ALINOUS_HOME is unset.");
        }
    }

    public void parseConfig() throws AlinousException {
        Element filter;
        Element basicAuth;
        String configPath = AlinousUtils.getAbsolutePath(this.alinousHome, ALINOUS_CONFIG);
        File configFile = new File(configPath);
        System.out.println("Config file is : " + configPath);
        if (!configFile.exists()) {
            throw new ConfigException("alinous-config.xml does not exists.");
        }
        Document doc = null;
        try {
            doc = new SAXBuilder().build(configFile);
        }
        catch (JDOMException e) {
            throw new AlinousException(e, null);
        }
        catch (IOException e) {
            throw new AlinousException(e, "alinous-config.xml is broken");
        }
        Element root = doc.getRootElement();
        List dataSrcList = root.getChildren(DATA_SOURCE_CONFIG);
        this.parseDataSourceConfig(dataSrcList);
        Element systemEl = root.getChild(SYSTEM);
        if (systemEl == null) {
            throw new ConfigException("<system> does not exists.");
        }
        this.parseSystemConfig(systemEl);
        Element mailTag = root.getChild(MAIL);
        if (mailTag != null) {
            this.parseMailConfig(mailTag);
        }
        if ((basicAuth = root.getChild(BASIC_AUTH)) != null) {
            this.parseBasicAuthConfig(basicAuth);
        }
        if ((filter = root.getChild(FILTER)) != null) {
            this.parseFilter(filter);
        }
    }

    private void parseFilter(Element filter) throws ConfigException {
        this.filterConfig = new FilterConfig();
        List zoneList = filter.getChildren(ZONE);
        for (Element zoneEl : zoneList) {
            Element outEl;
            Element areaEl = zoneEl.getChild(AREA);
            if (areaEl == null) continue;
            FilterZone zone = new FilterZone();
            String areaText = areaEl.getText();
            if (!areaText.endsWith("/")) {
                areaText = areaText + "/";
            }
            zone.setArea(areaText);
            if (areaEl == null) {
                throw new ConfigException("<area> does not exists.");
            }
            Element inEl = zoneEl.getChild(IN);
            if (inEl != null) {
                String inFilter = inEl.getText();
                zone.setInFilterClass(inFilter);
            }
            if ((outEl = zoneEl.getChild(OUT)) != null) {
                String outFilter = outEl.getText();
                zone.setOutFilterClass(outFilter);
            }
            this.filterConfig.addFilterZone(zone);
        }
    }

    private void parseBasicAuthConfig(Element basicAuth) throws ConfigException {
        this.securityConfig = new SecurityConfig();
        Element relmEl = basicAuth.getChild(RELM);
        if (relmEl == null) {
            throw new ConfigException("<relm> does not exists.");
        }
        Element datasourceEl = relmEl.getChild(RELM_DATASRC);
        if (datasourceEl == null) {
            throw new ConfigException("<datastore> does not exists.");
        }
        this.securityConfig.setRelmDataSource(datasourceEl.getText());
        Element tableEl = relmEl.getChild(RELM_TABLE);
        if (tableEl == null) {
            throw new ConfigException("<table> does not exists.");
        }
        this.securityConfig.setRelmTable(tableEl.getText());
        Element usersEl = relmEl.getChild(RELM_USERS);
        if (usersEl == null) {
            throw new ConfigException("<users> does not exists.");
        }
        this.securityConfig.setRelmUsers(usersEl.getText());
        Element passEl = relmEl.getChild(RELM_PASSWORDS);
        if (passEl == null) {
            throw new ConfigException("<passwords> does not exists.");
        }
        this.securityConfig.setRelmPasswords(passEl.getText());
        Element rolesEl = relmEl.getChild("roles");
        if (rolesEl == null) {
            throw new ConfigException("<roles> does not exists.");
        }
        this.securityConfig.setRelmRoles(rolesEl.getText());
        Element zonesEl = basicAuth.getChild(ZONES);
        if (zonesEl != null) {
            this.parseZones(zonesEl);
        }
    }

    private void parseZones(Element zonesEl) throws ConfigException {
        for (Element zoneEl : zonesEl.getChildren(ZONE)) {
            Element formAuthEl;
            Zone zone = new Zone();
            Element areaEl = zoneEl.getChild(AREA);
            if (areaEl == null) {
                throw new ConfigException("<area> does not exists.");
            }
            zone.setArea(areaEl.getText());
            Element rolesEl = zoneEl.getChild("roles");
            if (rolesEl == null) {
                throw new ConfigException("<roles> does not exists.");
            }
            zone.setRoles(rolesEl.getText());
            Element errPageEl = zoneEl.getChild(ERROR_PAGE);
            if (errPageEl != null) {
                zone.setErrorPage(errPageEl.getText());
            }
            if ((formAuthEl = zoneEl.getChild(FORM_AUTH)) != null) {
                this.parseFormAuth(formAuthEl, zone);
            }
            this.securityConfig.addZone(zone);
        }
    }

    private void parseFormAuth(Element formAuthEl, Zone zone) throws ConfigException {
        Element loginEl = formAuthEl.getChild(LOGIN_FORM);
        if (loginEl == null) {
            throw new ConfigException("<login> does not exists.");
        }
        zone.setLoginForm(loginEl.getText());
        Element confirmEl = formAuthEl.getChild(CONFIRM_FORM);
        if (confirmEl == null) {
            throw new ConfigException("<login> does not exists.");
        }
        zone.setConfirmForm(confirmEl.getText());
    }

    private void parseMailConfig(Element mailTag) throws ConfigException {
        Element popEl;
        Element authEl;
        this.mailconfig = new AlinousMailConfig();
        Element server = mailTag.getChild(SERVER);
        if (server == null) {
            throw new ConfigException("<server> does not exists.");
        }
        this.mailconfig.setServer(server.getText());
        Element portEl = mailTag.getChild(PORT);
        if (portEl == null) {
            throw new ConfigException("<port> does not exists.");
        }
        int po = 0;
        try {
            po = Integer.parseInt(portEl.getText());
        }
        catch (Throwable e) {
            throw new ConfigException("<port> must be a number.");
        }
        this.mailconfig.setPort(po);
        Element langEncEl = mailTag.getChild(LANG_ENCODE);
        if (langEncEl != null) {
            this.mailconfig.setLangCode(langEncEl.getText());
        }
        if ((authEl = mailTag.getChild(AUTH)) != null) {
            this.mailAuth(authEl);
        }
        if ((popEl = mailTag.getChild(POP_AUTH)) != null) {
            this.popAuth(popEl);
        }
    }

    private void popAuth(Element popEl) throws ConfigException {
        Element methodEL = popEl.getChild(METHOD);
        if (methodEL == null) {
            throw new ConfigException("pop-auth <method> does not exists.");
        }
        this.mailconfig.setPopMethod(methodEL.getText());
        Element userEl = popEl.getChild(USER);
        if (userEl == null) {
            throw new ConfigException("pop-auth <user> does not exists.");
        }
        this.mailconfig.setPopUser(userEl.getText());
        Element passEl = popEl.getChild(PASS);
        if (passEl == null) {
            throw new ConfigException("pop-auth <pass> does not exists.");
        }
        this.mailconfig.setPopPass(passEl.getText());
    }

    private void mailAuth(Element authEl) throws ConfigException {
        Element methodEL = authEl.getChild(METHOD);
        if (methodEL == null) {
            throw new ConfigException("<method> does not exists.");
        }
        this.mailconfig.setAuthMethod(methodEL.getText());
        Element userEl = authEl.getChild(USER);
        if (userEl == null) {
            throw new ConfigException("<user> does not exists.");
        }
        this.mailconfig.setAuthUser(userEl.getText());
        Element passEl = authEl.getChild(PASS);
        if (passEl == null) {
            throw new ConfigException("<pass> does not exists.");
        }
        this.mailconfig.setAuthPass(passEl.getText());
    }

    private void parseSystemConfig(Element systemEl) throws ConfigException {
        Element systemDataStore = systemEl.getChild(SYSTEM_REPOSITORY);
        if (systemDataStore == null) {
            throw new ConfigException("<system-datastore> does not exists.");
        }
        String id = systemDataStore.getAttributeValue("id");
        if (id == null) {
            throw new ConfigException("id attribute in <system-datastore> does not exists.");
        }
        this.systemRepositoryConfig = new SystemRepositoryConfig();
        this.systemRepositoryConfig.setSystemSrc(id);
        Element defaultDataStore = systemEl.getChild(DEFAULT_REPOSITORY);
        if (defaultDataStore == null) {
            throw new ConfigException("<default-datastore> does not exists.");
        }
        id = defaultDataStore.getAttributeValue("id");
        if (id == null) {
            throw new ConfigException("id attribute in <default-datastore> does not exists.");
        }
        Element uploadEl = systemEl.getChild("upload");
        if (uploadEl != null) {
            this.systemRepositoryConfig.setUploadMaxsize(uploadEl.getAttributeValue("maxsize"));
        } else {
            this.systemRepositoryConfig.setUploadMaxsize("10000000");
        }
        Element notfoundEl = systemEl.getChild("notfound");
        if (notfoundEl != null) {
            this.systemRepositoryConfig.setNotfoundPage(notfoundEl.getAttributeValue("page"));
        }
        this.systemRepositoryConfig.setDefaultSrc(id);
        Element encodeingEl = systemEl.getChild("encoding");
        if (encodeingEl != null) {
            this.systemRepositoryConfig.setEncoding(encodeingEl.getText());
        } else {
            this.systemRepositoryConfig.setEncoding("utf-8");
        }
    }

    private void parseDataSourceConfig(List dataSrcList) {
        for (Element el : dataSrcList) {
            String id = el.getAttributeValue("id");
            String clazz = el.getAttributeValue("class");
            Element elconnect = el.getChild("connect");
            Element eluser = el.getChild(USER);
            Element elpass = el.getChild(PASS);
            String connect = elconnect != null ? elconnect.getText() : null;
            String user = eluser != null ? eluser.getText() : null;
            String pass = elpass != null ? elpass.getText() : null;
            DataSourceConfig newConfig = new DataSourceConfig();
            newConfig.setId(id);
            newConfig.setClazz(clazz);
            newConfig.setUri(connect);
            newConfig.setUser(user);
            newConfig.setPass(pass);
            if (this.dataSourceConfigs == null) {
                this.dataSourceConfigs = new DataSourceConfigCollection();
            }
            this.dataSourceConfigs.addDataSourceConfig(newConfig);
        }
    }

    public DataSourceConfigCollection getDataSourceConfig() {
        return this.dataSourceConfigs;
    }

    public SystemRepositoryConfig getSystemRepositoryConfig() {
        return this.systemRepositoryConfig;
    }

    public AlinousMailConfig getMailConfig() {
        return this.mailconfig;
    }

    public SecurityConfig getSecurityConfig() {
        return this.securityConfig;
    }

    public FilterConfig getFilterConfig() {
        return this.filterConfig;
    }
}

