/*
 * Decompiled with CFR 0.152.
 */
package org.alinous;

import org.alinous.datasrc.exception.DataSourceException;
import org.alinous.expections.ExecutionException;
import org.alinous.logger.AlinousLogger;
import org.alinous.repository.AlinousSystemRepository;

public class AlinousMaintainThreadManager
implements Runnable {
    private boolean stop;
    private AlinousSystemRepository systemRepo;
    private Thread thread;
    private AlinousLogger log;

    public AlinousMaintainThreadManager(AlinousSystemRepository systemRepo, AlinousLogger log) {
        this.systemRepo = systemRepo;
    }

    public void start() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void stop() {
        this.stop = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        AlinousMaintainThreadManager alinousMaintainThreadManager = this;
        synchronized (alinousMaintainThreadManager) {
            this.loop();
        }
    }

    private void loop() {
        int sleepMilli = 3600;
        int i = 0;
        while (!this.stop) {
            if (i % sleepMilli == 0) {
                try {
                    this.systemRepo.cleanOldSessionData();
                }
                catch (ExecutionException e) {
                    this.log.reportError(e);
                }
                catch (DataSourceException e) {
                    this.log.reportError(e);
                }
                i = 0;
            }
            ++i;
            try {
                Thread.sleep(6000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

