/*
 * Decompiled with CFR 0.152.
 */
package org.alinous;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Timestamp;

public class AlinousUtils {
    public static final String SEPARATOR = "/";

    public static String getModuleName(String path) {
        String[] pathes = path.split("\\.");
        StringBuffer buffer = new StringBuffer();
        boolean isFirst = true;
        for (int i = 0; i < pathes.length - 1; ++i) {
            if (isFirst) {
                isFirst = false;
            } else {
                buffer.append(".");
            }
            buffer.append(pathes[i]);
        }
        return buffer.toString();
    }

    public static String getDirectory(String absPath) {
        if (absPath.endsWith(SEPARATOR)) {
            return absPath;
        }
        String[] pathes = absPath.split(SEPARATOR);
        StringBuffer buffer = new StringBuffer();
        for (int i = 1; i < pathes.length - 1; ++i) {
            buffer.append(SEPARATOR);
            buffer.append(pathes[i]);
        }
        buffer.append(SEPARATOR);
        return buffer.toString();
    }

    public static String getOSDirectory(String absPath) {
        if (absPath.endsWith(File.separator)) {
            return absPath;
        }
        String regSep = SEPARATOR;
        if (File.separator.equals("\\")) {
            regSep = "\\\\";
        }
        String[] pathes = absPath.split(regSep);
        StringBuffer buffer = new StringBuffer();
        for (int i = 1; i < pathes.length - 1; ++i) {
            buffer.append(File.separator);
            buffer.append(pathes[i]);
        }
        buffer.append(File.separator);
        return buffer.toString();
    }

    public static String getHomeBasedPath(String home, String target) {
        if (!home.endsWith(File.separator)) {
            home = home + File.separator;
        }
        if (!target.startsWith(home)) {
            return target;
        }
        return target.substring(home.length());
    }

    public static String getAbsolutePath(String home, String target) {
        if (!home.endsWith(File.separator)) {
            home = home + File.separator;
        }
        return home + target;
    }

    public static String formatAbsolute(String path) {
        if (path.startsWith(SEPARATOR)) {
            return path;
        }
        return SEPARATOR + path;
    }

    public static boolean isAlinousContent(String path) {
        return path.endsWith(".html") || path.endsWith(".rss") || path.endsWith(".alns");
    }

    public static String getOSPath(String webPath) {
        return webPath.replace(SEPARATOR, File.separator);
    }

    public static String getNotOSPath(String osPath) {
        return osPath.replace(File.separator, SEPARATOR);
    }

    public static String forceUnixPath(String path) {
        if (path == null) {
            return null;
        }
        return path.replace("\\", SEPARATOR);
    }

    public static String getStackTraceString(Throwable e) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter wr = new PrintWriter(stringWriter);
        e.printStackTrace(wr);
        return stringWriter.toString();
    }

    public static String getNowString() {
        long n = System.currentTimeMillis();
        Timestamp stmp = new Timestamp(n);
        return stmp.toString();
    }

    public static String md5(String str) {
        byte[] md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5").digest(str.getBytes());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < md5.length; ++i) {
            sb.append(Integer.toHexString(md5[i] >> 4 & 0xF));
            sb.append(Integer.toHexString(md5[i] & 0xF));
        }
        return new String(sb);
    }

    public static String sqlEscape(String str) {
        str = str.replaceAll("'", "''");
        return str;
    }

    public static boolean isUriReleavant(String attr) {
        if (attr == null) {
            return false;
        }
        return (attr = attr.toLowerCase()).equals("href") || attr.equals("src") || attr.equals("action") || attr.equals("href");
    }

    public static String toAlinousHttpHeaderName(String name) {
        name = name.toUpperCase();
        name = name.replace('-', '_');
        return name;
    }
}

