/*
 * Decompiled with CFR 0.152.
 */
package org.alinous;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alinous.expections.AlinousException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class MimeManager {
    private Map<String, String> contentTypes = new HashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MimeManager(InputStream stream) throws AlinousException {
        Document doc = null;
        try {
            doc = new SAXBuilder().build(stream);
        }
        catch (JDOMException e) {
            throw new AlinousException(e, null);
        }
        catch (IOException e) {
            throw new AlinousException(e, "mimetypes.xml is broken");
        }
        Element root = doc.getRootElement();
        try {
            this.parseElements(root);
        }
        finally {
            doc.clone();
        }
    }

    private void parseElements(Element root) {
        List mimeMappings = root.getChildren("mime-mapping");
        for (Element el : mimeMappings) {
            Element extEl = el.getChild("extension");
            Element contEl = el.getChild("mime-type");
            if (extEl == null || contEl == null) continue;
            String extention = extEl.getText();
            String content = contEl.getText();
            this.contentTypes.put(extention, content);
        }
    }

    public String getContentType(String extention) {
        String co = this.contentTypes.get(extention);
        if (co != null) {
            return co;
        }
        return "text/html";
    }
}

