/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.datasrc;

import java.util.ArrayList;
import java.util.List;
import org.alinous.datasrc.IAlinousDataSource;
import org.alinous.datasrc.basic.ILogProvidor;
import org.alinous.datasrc.exception.DataSourceException;
import org.alinous.datasrc.types.DataTable;
import org.alinous.datasrc.types.Record;
import org.alinous.expections.ExecutionException;
import org.alinous.script.sql.FromClause;
import org.alinous.script.sql.GroupByClause;
import org.alinous.script.sql.LimitOffsetClause;
import org.alinous.script.sql.OrderByClause;
import org.alinous.script.sql.SelectColumns;
import org.alinous.script.sql.SetClause;
import org.alinous.script.sql.WhereClause;
import org.alinous.script.sql.lock.ForUpdateClause;
import org.alinous.script.sql.other.ColumnList;
import org.alinous.script.sql.other.VariableList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSrcConnection {
    private ILogProvidor logger;
    private Object connectionHandle;
    private IAlinousDataSource dataSource;
    private boolean lastAutoCommit;
    private boolean trxStarted;

    public DataSrcConnection(IAlinousDataSource dataSource, ILogProvidor logger) {
        this.logger = logger;
        this.dataSource = dataSource;
        this.trxStarted = false;
    }

    public void connect() throws DataSourceException {
        this.connectionHandle = this.dataSource.connect();
    }

    public void close() {
        this.dataSource.close(this.connectionHandle);
    }

    public void createTable(DataTable table) throws DataSourceException {
        this.dataSource.createTable(this.connectionHandle, table);
    }

    public void dropTable(String table) throws DataSourceException {
        this.dataSource.dropTable(this.connectionHandle, table);
    }

    public ILogProvidor getLogger() {
        return this.logger;
    }

    public DataTable getDataTable(String tableName) throws DataSourceException {
        return this.dataSource.getDataTable(this.connectionHandle, tableName);
    }

    public void insert(Record record, String table) throws DataSourceException {
        this.dataSource.insert(this.connectionHandle, record, table, this.trxStarted);
    }

    public void insert(List<Record> records, String table) throws DataSourceException {
        this.dataSource.insert(this.connectionHandle, records, table, this.trxStarted);
    }

    public void insert(ColumnList cols, ArrayList<VariableList> valueLists, String table) throws DataSourceException, ExecutionException {
        this.dataSource.insert(this.connectionHandle, cols, valueLists, table, this.trxStarted);
    }

    public void delete(String table, WhereClause where) throws DataSourceException, ExecutionException {
        this.dataSource.delete(this.connectionHandle, table, where, this.trxStarted);
    }

    public void update(String table, SetClause set, WhereClause where) throws DataSourceException, ExecutionException {
        this.dataSource.update(this.connectionHandle, table, set, where, this.trxStarted);
    }

    public List<Record> select(String distinct, SelectColumns columns, FromClause from, WhereClause where, GroupByClause groupBy, OrderByClause orderBy, LimitOffsetClause limit, ForUpdateClause forupdate) throws DataSourceException, ExecutionException {
        return this.dataSource.select(this.connectionHandle, distinct, columns, from, where, groupBy, orderBy, limit, forupdate);
    }

    public void begin() throws DataSourceException {
        this.lastAutoCommit = this.dataSource.begin(this.connectionHandle);
        this.trxStarted = true;
    }

    public void commit() throws DataSourceException {
        this.dataSource.commit(this.connectionHandle, this.lastAutoCommit);
        this.trxStarted = false;
    }

    public void rollback() throws DataSourceException {
        this.dataSource.rollback(this.connectionHandle, this.lastAutoCommit);
        this.trxStarted = false;
    }

    public void setOutSql(boolean outSql) {
        this.dataSource.setOutSql(outSql);
    }
}

