/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.debug;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.CopyOnWriteArrayList;
import org.alinous.AlinousCore;
import org.alinous.debug.AlinousDebugManager;
import org.alinous.debug.DebugStackFrame;
import org.alinous.debug.DebugStackIdPublisher;
import org.alinous.debug.IThreadEventListner;
import org.alinous.debug.breakstatus.DefaultOperation;
import org.alinous.debug.breakstatus.IDebuggerOperation;
import org.alinous.exec.ExecutableJdomFactory;
import org.alinous.exec.IExecutable;
import org.alinous.expections.AlinousException;
import org.alinous.script.IScriptBlock;
import org.alinous.script.runtime.VariableRepository;
import org.jdom.Content;
import org.jdom.Element;

public class DebugThread {
    private Thread thread;
    private int status;
    private int statusReason;
    private long threadId;
    private List<IThreadEventListner> eventListners = new CopyOnWriteArrayList<IThreadEventListner>();
    private Stack<DebugStackFrame> stackFrames = new Stack();
    private IDebuggerOperation operation;
    private IExecutable nextExec;
    private DebugStackIdPublisher stackIdPublisher = new DebugStackIdPublisher();
    public static final int STATUS_NONE = 0;
    public static final int STATUS_RUNNING = 1;
    public static final int STATUS_SUSPEND = 10;
    public static final String TAG_THREAD = "THREAD";
    public static final String ATTR_THREAD_ID = "thread_id";
    public static final String ATTR_STATUS = "status";
    public static final String ATTR_STATUS_REASON = "status_reason";

    public DebugThread(long threadId) {
        this.threadId = threadId;
    }

    public DebugThread(Thread thread, AlinousDebugManager manager, IThreadEventListner listner) {
        this.thread = thread;
        this.status = 1;
        this.threadId = thread.getId();
        this.eventListners.add(listner);
        this.operation = new DefaultOperation();
        this.operation.init(this, manager);
    }

    public IDebuggerOperation getOperation() {
        return this.operation;
    }

    public void setOperation(IDebuggerOperation ope, AlinousDebugManager manager) {
        this.operation = ope;
        this.operation.init(this, manager);
    }

    public boolean equals(Object obj) {
        Thread target = (Thread)obj;
        return this.thread.getId() == target.getId();
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public synchronized void newStackFrame(IScriptBlock scriptBlock, VariableRepository repo) {
        DebugStackFrame frame = new DebugStackFrame(scriptBlock, repo);
        frame.setFileName(scriptBlock.getFilePath());
        frame.setLine(scriptBlock.getLine());
        long stackId = this.stackIdPublisher.publishId();
        frame.setStackId(stackId);
        frame.setPeek(true);
        if (!this.stackFrames.empty()) {
            this.stackFrames.peek().setPeek(false);
        }
        this.stackFrames.push(frame);
    }

    public synchronized void destroyStackFrame() {
        this.stackFrames.pop();
        if (!this.stackFrames.empty()) {
            this.stackFrames.peek().setPeek(true);
        }
    }

    public synchronized void exportIntoJDomElement(Element parent) {
        Element element = new Element(TAG_THREAD);
        element.setAttribute(ATTR_THREAD_ID, Long.toString(this.threadId));
        element.setAttribute(ATTR_STATUS, Integer.toString(this.status));
        element.setAttribute(ATTR_STATUS_REASON, Integer.toString(this.statusReason));
        for (DebugStackFrame frame : this.stackFrames) {
            frame.exportIntoJDomElement(element);
        }
        if (this.nextExec != null) {
            try {
                this.nextExec.exportIntoJDomElement(element);
            }
            catch (AlinousException e) {
                try {
                    AlinousCore.getInstance(null, null).reportError(e);
                }
                catch (Throwable ignore) {
                    ignore.printStackTrace();
                }
            }
        }
        parent.addContent((Content)element);
    }

    public void importFromJDomElement(Element threadElement) throws AlinousException {
        Element execElement;
        String strStatusReason;
        String strStatus;
        String strThreadId = threadElement.getAttributeValue(ATTR_THREAD_ID);
        if (strThreadId != null) {
            this.threadId = Long.parseLong(strThreadId);
        }
        if ((strStatus = threadElement.getAttributeValue(ATTR_STATUS)) != null) {
            this.status = Integer.parseInt(strStatus);
        }
        if ((strStatusReason = threadElement.getAttributeValue(ATTR_STATUS_REASON)) != null) {
            this.statusReason = Integer.parseInt(strStatusReason);
        }
        if ((execElement = threadElement.getChild("EXECUTABLE")) != null) {
            this.nextExec = ExecutableJdomFactory.createFirstExecutable(execElement);
            this.nextExec.importFromJDomElement(execElement);
        }
        for (Element stackFrameElement : threadElement.getChildren("STACKFRAME")) {
            DebugStackFrame frame = new DebugStackFrame(null, null);
            frame.importFromJDomElement(stackFrameElement);
            this.stackFrames.push(frame);
        }
    }

    public synchronized void suspend(final int reason, int line) throws InterruptedException {
        this.status = 10;
        this.statusReason = reason;
        DebugStackFrame topStack = this.stackFrames.peek();
        topStack.setLine(line);
        Thread backNotify = new Thread(new Runnable(){

            public void run() {
                DebugThread.this.fireSuspendThreadEventListner(reason);
            }
        });
        backNotify.run();
        this.wait();
    }

    public synchronized void resume() {
        this.status = 1;
        this.fireResumeThreadEventListner();
        this.notifyAll();
    }

    private void fireResumeThreadEventListner() {
        for (IThreadEventListner listner : this.eventListners) {
            listner.fireThreadResumed();
        }
    }

    private void fireSuspendThreadEventListner(int reason) {
        for (IThreadEventListner listner : this.eventListners) {
            listner.fireThreadAboutToSuspend(reason);
        }
    }

    public long getThreadId() {
        return this.threadId;
    }

    public int getStatusReason() {
        return this.statusReason;
    }

    public IExecutable getNextExec() {
        return this.nextExec;
    }

    public void setNextExec(IExecutable nextExec) {
        this.nextExec = nextExec;
    }

    public DebugStackFrame[] getStackFrames() {
        ArrayList<DebugStackFrame> arrayList = new ArrayList<DebugStackFrame>();
        for (DebugStackFrame frame : this.stackFrames) {
            arrayList.add(frame);
        }
        return arrayList.toArray(new DebugStackFrame[arrayList.size()]);
    }

    public DebugStackFrame getTopStackFrame() {
        return (DebugStackFrame)this.stackFrames.get(this.stackFrames.size() - 1);
    }
}

