/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.debug.command.client;

import java.util.HashMap;
import java.util.Map;
import org.alinous.debug.AlinousDebugManager;
import org.alinous.debug.AlinousServerDebugHttpResponse;
import org.alinous.debug.breakstatus.DefaultOperation;
import org.alinous.debug.command.client.IClientRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResumeRequest
implements IClientRequest {
    public static final String THREAD_ID = "THREAD_ID";
    private long threadId;

    public ResumeRequest(long threadId) {
        this.threadId = threadId;
    }

    @Override
    public AlinousServerDebugHttpResponse executeRequest(AlinousDebugManager debugManager) {
        debugManager.setOperation(this.threadId, new DefaultOperation());
        debugManager.setHotThread(this.threadId);
        debugManager.resume(this.threadId);
        AlinousServerDebugHttpResponse responce = new AlinousServerDebugHttpResponse(0);
        return responce;
    }

    @Override
    public String getCommand() {
        return "CMD_RESUME";
    }

    @Override
    public Map<String, String> getParamMap() {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put(THREAD_ID, Long.toString(this.threadId));
        return m;
    }

    @Override
    public void importParams(Map<String, String> params) {
        String strThreadId = params.get(THREAD_ID);
        if (strThreadId != null) {
            this.threadId = Long.parseLong(strThreadId);
        }
    }
}

