/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.exec;

import java.util.ArrayList;
import java.util.Iterator;
import org.alinous.AlinousConfig;
import org.alinous.AlinousUtils;
import org.alinous.datasrc.AlinousDataSourceManager;
import org.alinous.exec.BackingStatusCache;
import org.alinous.exec.ExecResultCache;
import org.alinous.exec.FormValueCache;
import org.alinous.exec.InnerModulePath;
import org.alinous.exec.InnerStatusCache;
import org.alinous.exec.SessionController;
import org.alinous.exec.pages.AlinousExecutableModule;
import org.alinous.exec.pages.ArrayParamValue;
import org.alinous.exec.pages.ConnectionManager;
import org.alinous.exec.pages.IDesign;
import org.alinous.exec.pages.IParamValue;
import org.alinous.exec.pages.PostContext;
import org.alinous.exec.validator.ValidationRequest;
import org.alinous.exec.validator.ValidationStatus;
import org.alinous.expections.AlinousException;
import org.alinous.expections.ModuleNotFoundException;
import org.alinous.objects.html.AlinousTopObject;
import org.alinous.repository.AlinousModule;
import org.alinous.repository.AlinousModuleRepository;
import org.alinous.repository.AlinousSystemRepository;
import org.alinous.script.runtime.IScriptVariable;
import org.alinous.security.AlinousSecurityManager;

public class AccessExecutionUnit {
    private AlinousModuleRepository parentRepository = null;
    private ExecResultCache execResultCache;
    private FormValueCache formValueCache;
    private InnerStatusCache innserStatusCache;
    private BackingStatusCache backingStatusCache;
    private SessionController sessionController;
    private AlinousConfig config;
    private AlinousSecurityManager securityManager;
    private String sessionId;
    private AlinousDataSourceManager dataSourceManager;
    private ConnectionManager connectionManager;
    private AlinousExecutableModule execModule;

    public AccessExecutionUnit(AlinousModuleRepository repo, String sessionId, AlinousSystemRepository sysrepo, AlinousDataSourceManager dataSourceManager) {
        this.parentRepository = repo;
        this.sessionId = sessionId;
        this.execResultCache = new ExecResultCache(sysrepo, this.sessionId);
        this.formValueCache = new FormValueCache(sysrepo, this.sessionId);
        this.innserStatusCache = new InnerStatusCache(sysrepo, this.sessionId);
        this.backingStatusCache = new BackingStatusCache(sysrepo, this.sessionId);
        this.sessionController = new SessionController(sysrepo, this.sessionId);
        this.dataSourceManager = dataSourceManager;
        this.connectionManager = new ConnectionManager(dataSourceManager);
    }

    public AccessExecutionUnit(AlinousModuleRepository repo, String sessionId, AlinousSystemRepository sysrepo, AlinousDataSourceManager dataSourceManager, AccessExecutionUnit parent) {
        this.parentRepository = repo;
        this.sessionId = sessionId;
        this.execResultCache = new ExecResultCache(sysrepo, this.sessionId);
        this.formValueCache = new FormValueCache(sysrepo, this.sessionId);
        this.innserStatusCache = new InnerStatusCache(sysrepo, this.sessionId);
        this.backingStatusCache = new BackingStatusCache(sysrepo, this.sessionId);
        this.sessionController = new SessionController(sysrepo, this.sessionId);
        this.dataSourceManager = dataSourceManager;
        this.connectionManager = new ConnectionManager(dataSourceManager, parent.getConnectionManager());
    }

    public IDesign gotoPage(String path, PostContext context) throws AlinousException {
        this.securityManager.checkSecurity(path, this.config, context);
        String formLastAction = context.getFormLastAction();
        String formLastTarget = context.getFormLastTargetTagId();
        String formLastFormId = context.getFormLastFormId();
        if (formLastAction != null && formLastTarget != null) {
            if (formLastFormId == null) {
                formLastFormId = "";
            }
            InnerModulePath innerModPath = new InnerModulePath(formLastTarget);
            this.formValueCache.storeFormValue(innerModPath, context.getParamMap(), formLastAction, formLastFormId);
            if (context.getNextAction() != null) {
                this.backingStatusCache.storeLastPath(innerModPath, context.getNextAction(), formLastAction);
            }
        }
        this.handleValidation(context);
        this.initCacheStatus(context);
        path = this.handleValidationDestination(path, context);
        return this.gotoPage(path, context, null, null);
    }

    private void initCacheStatus(PostContext context) {
        String targetPath = context.getTargetTagId();
        if (targetPath != null && !targetPath.equals("")) {
            return;
        }
        if (context.isBacking()) {
            context.setUseFormCache(true);
            context.setUseValuavleRepositoryCache(true);
        }
        if (!context.getValidationStatus().getStatus()) {
            context.setUseFormCache(true);
            context.setUseValuavleRepositoryCache(true);
        }
    }

    public IDesign gotoPage(String path, PostContext context, InnerModulePath currentPath, AlinousTopObject topObj) throws AlinousException {
        AlinousModule parentModule = this.parentRepository.getModule(path);
        if (parentModule == null) {
            throw new ModuleNotFoundException(path);
        }
        this.execModule = parentModule.fork();
        if (currentPath != null && this.execModule.getDesign() != null) {
            InnerModulePath newPath = currentPath.deepClone();
            this.execModule.setCurrentInnerModulePath(newPath);
        }
        if (topObj != null) {
            this.execModule.setTopTopObject(topObj);
        }
        this.execModule.post(context, this.execResultCache, this.dataSourceManager, this.config);
        return this.execModule.getDesign();
    }

    private String handleValidationDestination(String path, PostContext context) throws AlinousException {
        if (context.getValidationStatus().getStatus()) {
            return path;
        }
        String targetPath = context.getTargetTagId();
        if (targetPath != null && !targetPath.equals("")) {
            return path;
        }
        String lastAction = context.getFormLastAction();
        lastAction = AlinousUtils.getModuleName(lastAction);
        context.getCore().registerAlinousObject(lastAction);
        return lastAction;
    }

    private void handleValidation(PostContext context) throws AlinousException {
        ArrayList<ValidationRequest> list = new ArrayList<ValidationRequest>();
        Iterator<String> it = context.paramsIterator();
        while (it.hasNext()) {
            ValidationRequest req;
            String paramName;
            String fullParamName = paramName = it.next();
            IParamValue tmp = context.getParams(paramName);
            if (tmp instanceof ArrayParamValue) {
                fullParamName = paramName + "[]";
            }
            if ((req = ValidationRequest.getRequest(fullParamName, context.getParams(paramName), context.getParamMap())) == null) continue;
            list.add(req);
        }
        ValidationStatus status = new ValidationStatus();
        for (ValidationRequest request : list) {
            boolean result = request.validate(context);
            if (result) continue;
            status.addFailedRequest(request);
        }
        context.setValidationStatus(status);
    }

    public IScriptVariable executeValidation(PostContext context, String moduleName, String inputName, String formName, boolean isArray) throws AlinousException {
        AlinousModule parentModule = this.parentRepository.getModule(moduleName);
        if (parentModule == null) {
            throw new ModuleNotFoundException(moduleName);
        }
        this.execModule = parentModule.fork();
        IScriptVariable retVal = this.execModule.executeValidation(context, inputName, formName, isArray);
        return retVal;
    }

    public void setConfig(AlinousConfig config) {
        this.config = config;
    }

    public void setSecurityManager(AlinousSecurityManager securityManager) {
        this.securityManager = securityManager;
    }

    public InnerStatusCache getInnserStatusCache() {
        return this.innserStatusCache;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void dispose() {
        this.execModule = null;
        this.connectionManager.dispose();
    }

    public AlinousExecutableModule getExecModule() {
        return this.execModule;
    }

    public FormValueCache getFormValueCache() {
        return this.formValueCache;
    }

    public BackingStatusCache getBackingStatusCache() {
        return this.backingStatusCache;
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public SessionController getSessionController() {
        return this.sessionController;
    }
}

