/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.exec.pages;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.alinous.AlinousConfig;
import org.alinous.AlinousCore;
import org.alinous.AlinousUtils;
import org.alinous.datasrc.AlinousDataSourceManager;
import org.alinous.exec.AccessExecutionUnit;
import org.alinous.exec.ExecResultCache;
import org.alinous.exec.FormValueCache;
import org.alinous.exec.InnerModulePath;
import org.alinous.exec.pages.ArrayParamValue;
import org.alinous.exec.pages.FormValues;
import org.alinous.exec.pages.IParamValue;
import org.alinous.exec.pages.PostContext;
import org.alinous.exec.validator.CustomValidator;
import org.alinous.exec.validator.ValidationRequest;
import org.alinous.exec.validator.ValidationStatus;
import org.alinous.expections.AlinousException;
import org.alinous.expections.ExecutionException;
import org.alinous.expections.RedirectRequestException;
import org.alinous.objects.html.AlinousTopObject;
import org.alinous.repository.AlinousModule;
import org.alinous.script.AlinousScript;
import org.alinous.script.basic.type.IStatement;
import org.alinous.script.basic.type.StringConst;
import org.alinous.script.basic.type.VariableDescriptor;
import org.alinous.script.functions.FunctionDeclaration;
import org.alinous.script.functions.IFunction;
import org.alinous.script.runtime.IPathElement;
import org.alinous.script.runtime.IScriptVariable;
import org.alinous.script.runtime.PathElementFactory;
import org.alinous.script.runtime.ScriptArray;
import org.alinous.script.runtime.ScriptDomVariable;
import org.alinous.script.runtime.VariableRepository;
import org.alinous.script.statement.FuncArguments;

public class AlinousExecutableModule
extends AlinousModule {
    public AlinousExecutableModule(String path, AlinousTopObject ds, AlinousScript sc, long lastModified) {
        super(path, ds, sc, lastModified);
    }

    public AlinousExecutableModule(AlinousTopObject design, AlinousScript script) {
        this.design = design;
        this.script = script;
    }

    public void post(PostContext context, ExecResultCache resCache, AlinousDataSourceManager dataSourceManager, AlinousConfig config) throws AlinousException {
        VariableRepository valRepo = new VariableRepository();
        if (!context.isUseValuavleRepositoryCache()) {
            this.setupVariableRepository(context, valRepo, null);
        }
        if (this.script != null && !context.isUseValuavleRepositoryCache()) {
            this.script.setConfig(config);
            this.script.setDataSourceManager(dataSourceManager);
            context.getUnit().getSessionController().updateSession(valRepo, context);
            this.script.execute(context, valRepo);
            context.getUnit().getSessionController().storeSession(context, valRepo);
        } else if (this.design != null) {
            valRepo = resCache.getResultCache(this.design.getModulePath(), this.design.getPath());
            context.getUnit().getSessionController().updateSession(valRepo, context);
        }
        if (!context.isUseValuavleRepositoryCache()) {
            resCache.storeResult(context, valRepo, this.design.getModulePath(), this.design.getPath());
        }
        if (context.isUseFormCache()) {
            this.loadFormCache(context, valRepo);
        }
        this.editValidationInfo(context, valRepo);
        boolean forwarded = this.handleForwardReturn(context, valRepo);
        if (forwarded) {
            return;
        }
        if (this.design != null) {
            this.design.post(context, resCache, context.getUnit().getFormValueCache(), valRepo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleForwardReturn(PostContext context, VariableRepository valRepo) throws AlinousException {
        if (!context.isForwarded()) {
            return false;
        }
        String targetPath = ((ScriptDomVariable)context.getReturnedValue()).getValue();
        if (targetPath == null) {
            return false;
        }
        this.handleExraUrl(targetPath);
        if (targetPath.endsWith("/")) {
            targetPath = targetPath + "index.html";
        }
        AccessExecutionUnit accessUnit = null;
        try {
            accessUnit = context.getCore().createAccessExecutionUnit(context.getSessionId());
            PostContext newContext = new PostContext(context.getCore(), accessUnit);
            newContext.setContextPath(context.getContextPath());
            newContext.setServletPath(context.getContextPath());
            String osPath = AlinousUtils.getOSPath(targetPath);
            String moduleName = AlinousUtils.getModuleName(osPath);
            context.getCore().registerAlinousObject(moduleName);
            newContext.setRequestPath(moduleName);
            this.design = (AlinousTopObject)accessUnit.gotoPage(moduleName, newContext);
        }
        finally {
            if (accessUnit != null) {
                accessUnit.dispose();
            }
        }
        return true;
    }

    private void handleExraUrl(String targetPath) throws RedirectRequestException {
        if (targetPath.startsWith("http://") || targetPath.startsWith("https://")) {
            RedirectRequestException ex = new RedirectRequestException(targetPath);
            throw ex;
        }
    }

    private void editValidationInfo(PostContext context, VariableRepository valRepo) throws AlinousException {
        valRepo.release("VALIDATE", context);
        ValidationStatus status = context.getValidationStatus();
        if (status == null || status.getStatus()) {
            return;
        }
        Iterator<ValidationRequest> it = status.iterator();
        while (it.hasNext()) {
            ValidationRequest req = it.next();
            if (req.isCustom()) {
                this.handleCustomValidatorRequest(req, context, valRepo);
                continue;
            }
            StringBuffer valueName = new StringBuffer();
            valueName.append("VALIDATE");
            if (req.getFormName() != null && !req.getFormName().equals("")) {
                valueName.append(".");
                valueName.append(req.getFormName());
            }
            if (req.getInputName() != null && !req.getInputName().equals("")) {
                valueName.append(".");
                String inputStr = req.getInputName();
                if (inputStr.endsWith("[]")) {
                    inputStr = inputStr.substring(0, inputStr.length() - 2);
                }
                valueName.append(inputStr);
            }
            valueName.append(".");
            valueName.append(req.getValidatorName());
            valRepo.putValue(valueName.toString(), "true", "BOOLEAN", context);
        }
    }

    private void handleCustomValidatorRequest(ValidationRequest req, PostContext context, VariableRepository valRepo) throws ExecutionException {
        StringBuffer base = new StringBuffer();
        base.append("VALIDATE");
        if (req.getFormName() != null && !req.getFormName().equals("")) {
            base.append(".");
            base.append(req.getFormName());
        }
        if (req.getInputName() != null && !req.getInputName().equals("")) {
            base.append(".");
            base.append(req.getInputName());
        }
        CustomValidator customValidator = (CustomValidator)req.getValidator();
        for (String reason : customValidator.getReasons()) {
            StringBuffer valueName = new StringBuffer(base.toString());
            valueName.append(".");
            valueName.append(reason);
            valRepo.putValue(valueName.toString(), "true", "BOOLEAN", context);
        }
    }

    private void loadFormCache(PostContext context, VariableRepository valRepo) throws AlinousException {
        FormValueCache cache = context.getUnit().getFormValueCache();
        FormValues formValues = cache.loadFormValues(this.design.getModulePath(), this.design.getPath());
        context.setFormValues(formValues);
    }

    private boolean setupVariableRepository(PostContext context, VariableRepository valueRepo, String inputName) {
        boolean isArray = false;
        ScriptDomVariable inVariable = new ScriptDomVariable("IN");
        List<String> ignoreBlankList = context.getParamsToIgnoreBlank();
        Iterator<String> it = context.paramsIterator();
        while (it.hasNext()) {
            String key = it.next();
            IParamValue value = context.getParams(key);
            if (ignoreBlankList.contains(key) && value.getType() == 1 && ((Object)value).toString().equals("")) continue;
            switch (value.getType()) {
                case 1: {
                    ScriptDomVariable param = new ScriptDomVariable(key);
                    param.setValue(((Object)value).toString());
                    inVariable.put(param);
                    break;
                }
                case 2: {
                    this.setupArrayParam(key, inVariable, (ArrayParamValue)value);
                    if (inputName == null || !inputName.equals(key)) break;
                    isArray = true;
                    break;
                }
            }
        }
        valueRepo.putValue(inVariable);
        ScriptDomVariable httpHeaders = new ScriptDomVariable("HTTP");
        ScriptDomVariable header = new ScriptDomVariable("HEADER");
        httpHeaders.put(header);
        HashMap<String, String> map = context.getHttpHeaders();
        for (String name : map.keySet()) {
            ScriptDomVariable param = new ScriptDomVariable(name);
            param.setValue((String)map.get(name));
            header.put(param);
        }
        valueRepo.putValue(httpHeaders);
        return isArray;
    }

    private void setupArrayParam(String key, ScriptDomVariable inVariable, ArrayParamValue arrayParam) {
        ScriptArray arrayVariable = new ScriptArray(key);
        inVariable.put(arrayVariable);
        Iterator<String> it = arrayParam.getIterator();
        while (it.hasNext()) {
            String value = it.next();
            ScriptDomVariable vl = new ScriptDomVariable("");
            vl.setValue(value);
            vl.setValueType("STRING");
            arrayVariable.add(vl);
        }
    }

    public IScriptVariable executeValidation(PostContext context, String inputName, String formName, boolean isArray) throws AlinousException {
        VariableRepository valRepo = new VariableRepository();
        this.setupVariableRepository(context, valRepo, inputName);
        FunctionDeclaration funcDec = null;
        if (isArray) {
            if (inputName.endsWith("[]")) {
                inputName = inputName.substring(0, inputName.length() - "[]".length());
            }
            funcDec = this.script.getFuncDeclarations().findFunctionDeclare("validateArray");
        } else {
            funcDec = this.script.getFuncDeclarations().findFunctionDeclare("validate");
        }
        if (funcDec == null) {
            return null;
        }
        FuncArguments args = new FuncArguments();
        StringConst formNameArg = new StringConst();
        formNameArg.setStr(formName);
        StringConst inputNameArg = new StringConst();
        inputNameArg.setStr(inputName);
        VariableDescriptor valueStmt = this.variableDesc("IN." + inputName);
        VariableDescriptor inStmt = this.variableDesc("IN");
        VariableDescriptor sessionStmt = this.variableDesc("SESSION");
        args.addArgument(formNameArg);
        args.addArgument(inputNameArg);
        args.addArgument(valueStmt);
        args.addArgument(inStmt);
        args.addArgument(sessionStmt);
        context.getUnit().getSessionController().updateSession(valRepo, context);
        IScriptVariable valRes = this.executeSourceFunc(funcDec, context, valRepo, args);
        context.getUnit().getSessionController().storeSession(context, valRepo);
        return valRes;
    }

    private VariableDescriptor variableDesc(String domPath) {
        IPathElement pathEl = PathElementFactory.buildPathElement(domPath);
        return new VariableDescriptor("$", pathEl);
    }

    private IScriptVariable executeSourceFunc(FunctionDeclaration func, PostContext context, VariableRepository valRepo, FuncArguments args) throws ExecutionException {
        func.setConfig(context.getCore().getConfig());
        func.setDataSourceManager(context.getCore().getDataSourceManager());
        this.handleRuntimeArguments(func, args);
        func.setCallerSentence(func);
        if (AlinousCore.debug) {
            context.getCore().getAlinousDebugManager().createStackFrame(func, valRepo);
        }
        func.execute(context, valRepo);
        if (AlinousCore.debug) {
            context.getCore().getAlinousDebugManager().destoryStackFrame();
        }
        return func.getResult();
    }

    private void handleRuntimeArguments(IFunction func, FuncArguments args) {
        if (args == null) {
            return;
        }
        Stack<IStatement> stmtStack = new Stack<IStatement>();
        Iterator<IStatement> it = args.iterator();
        while (it.hasNext()) {
            IStatement stmt = it.next();
            stmtStack.push(stmt);
        }
        func.inputArguments(stmtStack);
    }

    public void setCurrentInnerModulePath(InnerModulePath currentInnerModulePath) {
        if (this.design != null) {
            this.design.setModulePath(currentInnerModulePath);
        }
    }

    public void setTopTopObject(AlinousTopObject topObj) {
        if (this.design != null) {
            this.design.setTopTopObject(topObj);
        }
    }
}

