/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.exec.pages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.alinous.AlinousCore;
import org.alinous.exec.AccessExecutionUnit;
import org.alinous.exec.pages.FormValues;
import org.alinous.exec.pages.IParamValue;
import org.alinous.exec.pages.PageHttpContext;
import org.alinous.exec.pages.PostParams;
import org.alinous.exec.validator.ValidationStatus;
import org.alinous.expections.ExecutionException;
import org.alinous.script.runtime.IPathElement;
import org.alinous.script.runtime.IScriptVariable;
import org.alinous.script.runtime.ScriptDomVariable;
import org.alinous.script.runtime.VariableRepository;
import org.alinous.security.AuthenticationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostContext {
    private PostParams params = new PostParams();
    private HashMap<String, String> httpHeaders = new HashMap();
    private String userName;
    private String requestPath;
    private PageHttpContext httpContext;
    private AccessExecutionUnit unit;
    private AlinousCore core;
    private boolean useFormCache;
    private boolean useValuavleRepositoryCache;
    private boolean isInner;
    private IScriptVariable returnedValue;
    private FormValues formValues = new FormValues();
    private ValidationStatus validationStatus;
    private Stack<RegisterPair> plueplueReserved = new Stack();
    private AuthenticationContext authContext;
    private String contextPath;
    private String servletPath;

    public PostContext(AlinousCore core, AccessExecutionUnit unit) {
        this.core = core;
        this.unit = unit;
    }

    public void initParams(String moduleName, Map<String, IParamValue> params) {
        this.params = new PostParams();
        this.params.initParams(params);
    }

    public void initParams(PostContext context) {
        this.params.initParams(context.params);
        this.validationStatus = context.getValidationStatus();
        this.requestPath = context.getRequestPath();
        this.userName = context.getUserName();
        this.servletPath = context.servletPath;
        this.contextPath = context.contextPath;
        this.initHttpHeaders(context.httpHeaders);
    }

    public void initHttpHeaders(Map<String, String> m) {
        for (String name : m.keySet()) {
            this.httpHeaders.put(name, m.get(name));
        }
    }

    public IParamValue getParams(String key) {
        return this.params.get(key);
    }

    public Iterator<String> paramsIterator() {
        return this.params.paramKeyIterator();
    }

    public HashMap<String, IParamValue> getParamMap() {
        return this.params.getParamMap();
    }

    public boolean isBacking() {
        IParamValue backing = this.params.get("alns:back");
        if (backing == null) {
            return false;
        }
        return ((Object)backing).toString().toLowerCase().equals("true");
    }

    public void setBacking() {
        this.params.addParam("alns:back", "true");
    }

    public String getNextAction() {
        IParamValue paramValue = this.params.get("alns:formAction");
        if (paramValue == null) {
            return null;
        }
        return ((Object)paramValue).toString();
    }

    public void resetNextAction() {
        this.params.removeParam("alns:formAction");
    }

    public void setNextAction(String value) {
        this.params.setParamValue("alns:formAction", value);
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public AlinousCore getCore() {
        return this.core;
    }

    public String getSessionId() {
        return this.unit.getSessionId();
    }

    public String getTargetTagId() {
        IParamValue paramValue = this.params.get("alns:formTargetTagId");
        if (paramValue == null) {
            return null;
        }
        return ((Object)paramValue).toString();
    }

    public void setTargetTagId(String tagId) {
        this.params.addParam("alns:formTargetTagId", tagId);
    }

    public String getFormLastAction() {
        IParamValue paramValue = this.params.get("alns:formLastAction");
        if (paramValue == null) {
            return null;
        }
        return ((Object)paramValue).toString();
    }

    public String getFormLastTargetTagId() {
        IParamValue paramValue = this.params.get("alns:formLastTargetTagId");
        if (paramValue == null) {
            return null;
        }
        return ((Object)paramValue).toString();
    }

    public String getFormLastFormId() {
        IParamValue paramValue = this.params.get("alns:formLastFormId");
        if (paramValue == null) {
            return null;
        }
        return ((Object)paramValue).toString();
    }

    public AccessExecutionUnit getUnit() {
        return this.unit;
    }

    public boolean isUseFormCache() {
        return this.useFormCache;
    }

    public void setUseFormCache(boolean useFormCache) {
        this.useFormCache = useFormCache;
    }

    public boolean isUseValuavleRepositoryCache() {
        return this.useValuavleRepositoryCache;
    }

    public void setUseValuavleRepositoryCache(boolean useValuavleRepositoryCache) {
        this.useValuavleRepositoryCache = useValuavleRepositoryCache;
    }

    public boolean isInner() {
        return this.isInner;
    }

    public void setInner(boolean isInner) {
        this.isInner = isInner;
    }

    public void addPluePlus(ScriptDomVariable val, IPathElement path) {
        RegisterPair pair = new RegisterPair();
        pair.inc = true;
        pair.valable = val;
        pair.path = path;
        this.plueplueReserved.push(pair);
    }

    public void addMinusMinus(ScriptDomVariable val, IPathElement path) {
        RegisterPair pair = new RegisterPair();
        pair.inc = false;
        pair.valable = val;
        pair.path = path;
        this.plueplueReserved.push(pair);
    }

    public void handleReservedOperations(VariableRepository valRepo) throws ExecutionException {
        while (this.plueplueReserved.size() > 0) {
            RegisterPair pair = this.plueplueReserved.pop();
            if (pair.inc) {
                pair.valable.incInt();
            } else {
                pair.valable.decInt();
            }
            valRepo.putValue(pair.path, pair.valable, this);
        }
    }

    public FormValues getFormValues() {
        return this.formValues;
    }

    public void setFormValues(FormValues formValues) {
        this.formValues = formValues;
    }

    public ValidationStatus getValidationStatus() {
        return this.validationStatus;
    }

    public void setValidationStatus(ValidationStatus validationStatus) {
        this.validationStatus = validationStatus;
    }

    public IScriptVariable getReturnedValue() {
        return this.returnedValue;
    }

    public void setReturnedValue(IScriptVariable returnedValue) {
        this.returnedValue = returnedValue;
    }

    public boolean isForwarded() {
        if (this.isBacking()) {
            return false;
        }
        if (this.isUseFormCache()) {
            return false;
        }
        if (this.isUseValuavleRepositoryCache()) {
            return false;
        }
        if (!this.getValidationStatus().getStatus()) {
            return false;
        }
        if (this.returnedValue == null) {
            return false;
        }
        if (!(this.returnedValue instanceof ScriptDomVariable)) {
            return false;
        }
        ScriptDomVariable dom = (ScriptDomVariable)this.returnedValue;
        return dom.getValueType().equals("STRING");
    }

    public List<String> getParamsToIgnoreBlank() {
        ArrayList<String> list = new ArrayList<String>();
        for (String key : this.params.getParamMap().keySet()) {
            if (!key.startsWith("alns:ignoreblank")) continue;
            list.add(key.substring("alns:ignoreblank".length() + 1));
        }
        return list;
    }

    public String getRequestPath() {
        return this.requestPath;
    }

    public void setRequestPath(String requestPath) {
        this.requestPath = requestPath;
    }

    public AuthenticationContext getAuthContext() {
        return this.authContext;
    }

    public void setAuthContext(AuthenticationContext authContext) {
        this.authContext = authContext;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    public String getFilePath(String path) {
        if (!path.startsWith("/")) {
            return path;
        }
        return this.contextPath + this.servletPath + path;
    }

    public PageHttpContext getHttpContext() {
        return this.httpContext;
    }

    public void setHttpContext(PageHttpContext httpContext) {
        this.httpContext = httpContext;
    }

    public HashMap<String, String> getHttpHeaders() {
        return this.httpHeaders;
    }

    class RegisterPair {
        public ScriptDomVariable valable;
        public IPathElement path;
        public boolean inc;

        RegisterPair() {
        }
    }
}

