/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.exec.validator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.alinous.AlinousCore;
import org.alinous.AlinousUtils;
import org.alinous.exec.AccessExecutionUnit;
import org.alinous.exec.pages.IParamValue;
import org.alinous.exec.pages.PostContext;
import org.alinous.exec.validator.IValidator;
import org.alinous.expections.AlinousException;
import org.alinous.expections.ExecutionException;
import org.alinous.script.runtime.IScriptVariable;
import org.alinous.script.runtime.ScriptArray;
import org.alinous.script.runtime.ScriptDomVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomValidator
implements IValidator {
    private List<String> reasons = new ArrayList<String>();
    private String InputName;
    private String formName;

    @Override
    public void setRegExp(String regExp) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean validate(IParamValue param, PostContext context, boolean isArray) throws AlinousException {
        AlinousCore core = context.getCore();
        String moduleName = context.getRequestPath();
        if (context.getNextAction() != null) {
            String nextAction = context.getNextAction();
            moduleName = AlinousUtils.getModuleName(nextAction);
        }
        core.registerAlinousObject(moduleName);
        AccessExecutionUnit unit = null;
        IScriptVariable valResult = null;
        try {
            unit = core.createAccessExecutionUnit(context.getSessionId());
            PostContext newContext = new PostContext(core, unit);
            newContext.initParams(context);
            valResult = unit.executeValidation(newContext, moduleName, this.InputName, this.formName, isArray);
        }
        finally {
            unit.dispose();
        }
        if (valResult == null) {
            return true;
        }
        if (valResult instanceof ScriptDomVariable) {
            this.handleReason((ScriptDomVariable)valResult);
        } else if (valResult instanceof ScriptArray) {
            this.handleReason((ScriptArray)valResult);
        } else {
            throw new ExecutionException("FATAL ERROR");
        }
        return this.reasons == null || this.reasons.size() == 0;
    }

    private void handleReason(ScriptDomVariable val) {
        if (!val.getValueType().equals("STRING")) {
            return;
        }
        String str = val.getValue();
        this.reasons.add(str);
    }

    private void handleReason(ScriptArray arrayVal) {
        Iterator<IScriptVariable> it = arrayVal.iterator();
        while (it.hasNext()) {
            IScriptVariable scVal = it.next();
            if (scVal instanceof ScriptDomVariable) {
                this.handleReason((ScriptDomVariable)scVal);
                continue;
            }
            this.handleReason((ScriptArray)scVal);
        }
    }

    public List<String> getReasons() {
        return this.reasons;
    }

    @Override
    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public void setInputName(String inputName) {
        this.InputName = inputName;
    }
}

