/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.jdk;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipException;
import org.alinous.AlinousDebug;
import org.alinous.AlinousUtils;
import org.alinous.jdk.AlinousURLStreamHandler;
import org.alinous.jdk.ClassEntry;
import org.alinous.jdk.JarEntry;
import org.alinous.jdk.JarScanner;
import org.alinous.jdk.JavaConnectorFunctionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlinousClassLoader
extends ClassLoader {
    private List<JarEntry> entries = new ArrayList<JarEntry>();
    private Map<String, Class<?>> loadedClass = new Hashtable();
    private JarScanner scnner;
    private JavaConnectorFunctionManager mgr;

    public static AlinousClassLoader createClassLoader(ClassLoader parent, String libDir, JavaConnectorFunctionManager mgr) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        AlinousClassLoader loader = new AlinousClassLoader(parent);
        loader.mgr = mgr;
        loader.update(libDir);
        return loader;
    }

    public boolean isDirty(String libDir) {
        this.scnner = new JarScanner(libDir);
        List<String> jarFiles = this.scan();
        for (String jarFileStr : jarFiles) {
            String fileAbsPath = AlinousUtils.getAbsolutePath(libDir, jarFileStr);
            File file = new File(fileAbsPath);
            long tm = file.lastModified();
            JarEntry lastEntry = this.findEntry(jarFileStr);
            if (lastEntry == null) {
                return true;
            }
            long lastTm = lastEntry.getTimestamp();
            if (tm <= lastTm) continue;
            return true;
        }
        for (JarEntry entry : this.entries) {
            String jarFileStr = entry.getJarName();
            String fileAbsPath = AlinousUtils.getAbsolutePath(libDir, jarFileStr);
            File file = new File(fileAbsPath);
            if (file.exists()) continue;
            return true;
        }
        return false;
    }

    protected synchronized void update(String libDir) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        this.scnner = new JarScanner(libDir);
        boolean changed = false;
        List<String> jarFiles = this.scan();
        for (String jarFileStr : jarFiles) {
            String fileAbsPath = AlinousUtils.getAbsolutePath(libDir, jarFileStr);
            File file = new File(fileAbsPath);
            long tm = file.lastModified();
            JarEntry lastEntry = this.findEntry(jarFileStr);
            if (lastEntry == null) {
                this.newEntry(libDir, jarFileStr, file);
                changed = true;
                continue;
            }
            long lastTm = lastEntry.getTimestamp();
            if (tm <= lastTm) continue;
            this.entries.remove(lastEntry);
            this.newEntry(libDir, jarFileStr, file);
            changed = true;
        }
        ArrayList<JarEntry> removeEntry = new ArrayList<JarEntry>();
        for (JarEntry entry : this.entries) {
            String jarFileStr = entry.getJarName();
            String fileAbsPath = AlinousUtils.getAbsolutePath(libDir, jarFileStr);
            File file = new File(fileAbsPath);
            if (file.exists()) continue;
            removeEntry.add(entry);
            changed = true;
        }
        for (JarEntry entry : removeEntry) {
            AlinousDebug.print("removed : " + entry.getJarName() + "\n");
            this.entries.remove(entry);
        }
        Iterator<JarEntry> jarEntIt = this.entries.iterator();
        while (jarEntIt.hasNext() && changed) {
            JarEntry entry;
            entry = jarEntIt.next();
            entry.registerFunctionContainer(this);
        }
    }

    private void newEntry(String basePath, String jarFileName, File file) throws InstantiationException, IllegalAccessException {
        long tm = file.lastModified();
        JarEntry entry = new JarEntry(basePath, jarFileName, tm, this.mgr);
        try {
            entry.init();
        }
        catch (ZipException e) {
            e.printStackTrace();
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        this.entries.add(entry);
    }

    private JarEntry findEntry(String jarFileName) {
        for (JarEntry entry : this.entries) {
            if (!entry.getJarName().equals(jarFileName)) continue;
            return entry;
        }
        return null;
    }

    protected AlinousClassLoader(ClassLoader parent) {
        super(parent);
    }

    public List<String> scan() {
        return this.scnner.scanDir();
    }

    @Override
    public URL getResource(String name) {
        for (JarEntry jarEntry : this.entries) {
            ClassEntry entry = jarEntry.findClassEntry(name);
            if (entry == null) continue;
            AlinousURLStreamHandler handler = new AlinousURLStreamHandler();
            handler.setByteData(entry.getBytes());
            try {
                URL url = new URL("alinous", "localhost", -1, entry.getName(), handler);
                return url;
            }
            catch (MalformedURLException e) {
                e.fillInStackTrace();
                return null;
            }
        }
        return super.getResource(name);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> clazz = this.doFindClass(name);
        if (clazz != null) {
            return clazz;
        }
        return super.findClass(name);
    }

    private Class<?> doFindClass(String name) {
        for (JarEntry jEntry : this.entries) {
            ClassEntry entry = jEntry.findClassEntry(name);
            if (entry == null) continue;
            return this.loadClass(entry);
        }
        return null;
    }

    public synchronized Class<?> loadClass(ClassEntry entry) {
        if (entry.isResource()) {
            return null;
        }
        Class<?> clazz = this.loadedClass.get(entry.getName());
        if (clazz != null) {
            return clazz;
        }
        byte[] b = entry.getBytes();
        clazz = this.defineClass(entry.getName(), b, 0, b.length);
        this.loadedClass.put(entry.getName(), clazz);
        return clazz;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, true);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = super.loadClass(name, resolve);
        this.loadedClass.put(name, clazz);
        return clazz;
    }
}

