/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.jdk;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipException;
import org.alinous.jdk.AlinousClassLoader;
import org.alinous.jdk.ClassEntry;
import org.alinous.jdk.JarHandler;
import org.alinous.jdk.JavaConnectorFunctionManager;

public class JarEntry {
    private long timestamp;
    private String jarName;
    private String basePath;
    private Map<String, ClassEntry> classEntries;
    private JavaConnectorFunctionManager mgr;

    public JarEntry(String basePath, String jarName, long tm, JavaConnectorFunctionManager mgr) {
        this.basePath = basePath;
        this.jarName = jarName;
        this.timestamp = tm;
        this.mgr = mgr;
    }

    public void init() throws ZipException, IOException, InstantiationException, IllegalAccessException {
        JarHandler jarHandler = new JarHandler(this.jarName, this.basePath);
        this.classEntries = new HashMap<String, ClassEntry>();
        List<ClassEntry> entryList = jarHandler.initEntries();
        for (ClassEntry ent : entryList) {
            this.classEntries.put(ent.getName(), ent);
        }
    }

    public void registerFunctionContainer(AlinousClassLoader loader) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        for (String key : this.classEntries.keySet()) {
            ClassEntry entry = this.findClassEntry(key);
            if (entry.isResource()) continue;
            this.mgr.registerClassCallback(entry, loader);
        }
    }

    public ClassEntry findClassEntry(String name) {
        return this.classEntries.get(name);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getJarName() {
        return this.jarName;
    }

    public void setJarName(String jarName) {
        this.jarName = jarName;
    }

    public boolean equals(Object obj) {
        if (obj instanceof JarEntry) {
            return ((JarEntry)obj).getJarName().equals(this.jarName);
        }
        return super.equals(obj);
    }
}

