/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.jdk;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.alinous.AlinousCore;
import org.alinous.AlinousDebug;
import org.alinous.expections.ExecutionException;
import org.alinous.jdk.AlinousClassLoader;
import org.alinous.jdk.ClassEntry;
import org.alinous.jdk.FunctionConitainer;
import org.alinous.jdk.IFunctionUtils;
import org.alinous.jdk.model.FunctionModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaConnectorFunctionManager
implements Runnable {
    public static final String LIB_PATH = "lib";
    private String libPath;
    private AlinousClassLoader loader;
    private AlinousCore alinousCore;
    private boolean scanStart;
    private Thread thread;
    private Map<String, FunctionConitainer> functions = new HashMap<String, FunctionConitainer>();

    public JavaConnectorFunctionManager(String alinousHome, AlinousCore core) {
        if (!alinousHome.endsWith(File.separator)) {
            alinousHome = alinousHome + File.separator;
        }
        this.libPath = alinousHome + LIB_PATH + File.separator;
        this.alinousCore = core;
    }

    public void init() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        this.loader = AlinousClassLoader.createClassLoader(this.getClass().getClassLoader(), this.libPath, this);
    }

    public synchronized void update() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (this.loader.isDirty(this.libPath)) {
            this.loader = null;
            this.loader = AlinousClassLoader.createClassLoader(this.getClass().getClassLoader(), this.libPath, this);
        }
    }

    public synchronized Class<?> loadClass(String className) throws ClassNotFoundException {
        return this.loader.loadClass(className);
    }

    public synchronized void registerClassCallback(ClassEntry classEntry, AlinousClassLoader defaultloader) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Class<?> clazz = null;
        try {
            clazz = defaultloader.loadClass(classEntry);
        }
        catch (NoClassDefFoundError e) {
            AlinousDebug.debugOut("Ignored " + classEntry.getName());
            return;
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> itf = interfaces[i];
            if (!itf.getName().equals(IFunctionUtils.CLASS_NAME)) continue;
            Object obj = clazz.newInstance();
            FunctionConitainer container = new FunctionConitainer(obj, defaultloader, this.alinousCore);
            this.functions.put(container.getPrefix(), container);
            System.out.println("Detected function Container : " + clazz.getName());
        }
    }

    public FunctionModel findFunction(String name) throws ExecutionException {
        String[] names = name.split("\\.");
        if (names.length != 2) {
            return null;
        }
        FunctionConitainer container = this.functions.get(names[0]);
        if (container == null) {
            throw new ExecutionException("The native function does not registered.");
        }
        return container.findMethod(names[1]);
    }

    public void startScan() {
        this.scanStart = true;
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void endScan() {
        this.scanStart = false;
        this.thread = null;
    }

    @Override
    public void run() {
        while (this.scanStart) {
            try {
                this.update();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

