/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.net.mail;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.alinous.expections.AlinousException;
import org.alinous.expections.ExecutionException;
import org.alinous.expections.MailException;
import org.alinous.net.mail.AlinousMailConfig;
import org.alinous.net.mail.SmtpProtocol;
import org.alinous.net.pop3.PassCommand;
import org.alinous.net.pop3.Pop3Protocl;
import org.alinous.net.pop3.QuitCommand;
import org.alinous.net.pop3.UserCommand;

public class MailWrapper {
    private SmtpProtocol protocol;
    private List<String> bccList = new ArrayList<String>();
    private AlinousMailConfig mailconfig;

    public MailWrapper(AlinousMailConfig mailconfig) {
        this.protocol = new SmtpProtocol();
        this.mailconfig = mailconfig;
        this.protocol.setSmtpServer(mailconfig.getServer());
        this.protocol.setSmtpPort(mailconfig.getPort());
        this.protocol.setLangEncoding(mailconfig.getLangCode());
    }

    public void popcheck() throws ExecutionException {
        Pop3Protocl protocol = new Pop3Protocl();
        protocol.setUser(this.mailconfig.getPopUser());
        protocol.setPass(this.mailconfig.getPopPass());
        protocol.setPopServer(this.mailconfig.getServer());
        try {
            protocol.connect();
            UserCommand userCom = new UserCommand(protocol);
            userCom.sendCommand(protocol.getCon());
            userCom.receiveCommand(protocol.getCon());
            PassCommand passCom = new PassCommand(protocol);
            passCom.sendCommand(protocol.getCon());
            passCom.receiveCommand(protocol.getCon());
            QuitCommand quitCom = new QuitCommand(protocol);
            quitCom.sendCommand(protocol.getCon());
            quitCom.receiveCommand(protocol.getCon());
        }
        catch (UnknownHostException e) {
            throw new ExecutionException(e, "Pop before SMTP error,");
        }
        catch (IOException e) {
            throw new ExecutionException(e, "Pop before SMTP error,");
        }
        catch (MailException e) {
            throw new ExecutionException(e, "Pop before SMTP error,");
        }
        finally {
            protocol.disconnect();
        }
    }

    public void sendMail(String fromAddress, String subject, String body) {
        this.protocol.setSubject(subject);
        this.protocol.setBody(body);
        this.protocol.setFromAddress(fromAddress);
        for (String receiver : this.protocol.getToAddress()) {
            try {
                this.protocol.sendMultiple(receiver, this.mailconfig.getAuthUser(), this.mailconfig.getAuthPass(), this.mailconfig.getAuthMethod());
            }
            catch (MailException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        for (String receiver : this.protocol.getCcAddress()) {
            try {
                this.protocol.sendMultiple(receiver, this.mailconfig.getAuthUser(), this.mailconfig.getAuthPass(), this.mailconfig.getAuthMethod());
            }
            catch (MailException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        for (String receiver : this.bccList) {
            try {
                this.protocol.sendMultiple(receiver, this.mailconfig.getAuthUser(), this.mailconfig.getAuthPass(), this.mailconfig.getAuthMethod());
            }
            catch (MailException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void addTo(String to) {
        this.protocol.addToAddress(to);
    }

    public void addCc(String cc) {
        this.protocol.addCcAddress(cc);
    }

    public void addBcc(String bcc) {
        this.bccList.add(bcc);
    }

    public void reset() {
        this.bccList.clear();
    }

    public void connect() throws AlinousException {
        try {
            this.protocol.connect();
        }
        catch (UnknownHostException e) {
            throw new AlinousException(e, "Failed in connect to mail server.");
        }
        catch (IOException e) {
            throw new AlinousException(e, "Failed in connect to mail server.");
        }
        try {
            this.protocol.recv();
            this.protocol.helloCommand();
        }
        catch (IOException e) {
            this.protocol.disconnect();
            throw new AlinousException(e, "Failed in connect to mail server.");
        }
        String authWay = this.mailconfig.getAuthMethod();
        if (authWay != null && authWay.toUpperCase().equals("LOGIN")) {
            this.protocol.setUserName(this.mailconfig.getAuthUser());
            this.protocol.setPassword(this.mailconfig.getAuthPass());
            try {
                this.protocol.doAuthLogin();
            }
            catch (IOException e) {
                this.protocol.disconnect();
                throw new AlinousException(e, "Failed in authentication.");
            }
        }
    }

    public void disconnect() {
        this.protocol.disconnect();
    }
}

