/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.objects.html;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.alinous.exec.pages.ArrayParamValue;
import org.alinous.exec.pages.FormValues;
import org.alinous.exec.pages.IParamValue;
import org.alinous.exec.pages.PostContext;
import org.alinous.exec.pages.StringParamValue;
import org.alinous.expections.AlinousException;
import org.alinous.expections.ExecutionException;
import org.alinous.objects.Attribute;
import org.alinous.objects.DqString;
import org.alinous.objects.IAlinousObject;
import org.alinous.objects.IAttributeValue;
import org.alinous.objects.XMLTagBase;
import org.alinous.objects.html.AlinousTopObject;
import org.alinous.objects.html.FormTagObject;
import org.alinous.objects.html.IHtmlObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputTagObject
extends XMLTagBase
implements IHtmlObject {
    public static final String ATTR_NAME = "name";
    public static final String ATTR_VALUE = "value";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_CHECKED = "checked";
    public static final String TYPE_TEXT = "text";
    public static final String TYPE_RADIO = "radio";
    public static final String TYPE_CHECKBOX = "checkbox";

    @Override
    public IAlinousObject fork() throws AlinousException {
        InputTagObject newObj = new InputTagObject();
        this.copyAttribute(this, newObj);
        this.forkInnerObjects(newObj);
        return newObj;
    }

    @Override
    public void renderContents(PostContext context, Writer wr, int n) throws IOException, AlinousException {
        if (!this.handleIf(context)) {
            return;
        }
        if (this.handleIterateAttribute(context, wr, n)) {
            return;
        }
        this.doRenderContent(context, wr, n);
    }

    @Override
    protected void doRenderContent(PostContext context, Writer wr, int n) throws IOException, AlinousException {
        if (context.isUseFormCache()) {
            this.handleCache(context);
        }
        wr.append("<input");
        this.renderAttributes(wr, 0, false, true);
        this.renderValue(context, wr);
        wr.append(">");
        ArrayList<XMLTagBase.FormHiddenValue> hiddens = new ArrayList<XMLTagBase.FormHiddenValue>();
        this.handleValidationInfo(context, hiddens);
        this.handleIgnoreBlank(hiddens);
        this.registerHidden(hiddens);
    }

    private void registerHidden(List<XMLTagBase.FormHiddenValue> hiddens) {
        FormTagObject formTagObject = this.getFormTagObject();
        if (formTagObject == null) {
            return;
        }
        for (XMLTagBase.FormHiddenValue hd : hiddens) {
            formTagObject.addChildHidden(hd);
        }
    }

    private void handleIgnoreBlank(List<XMLTagBase.FormHiddenValue> hiddens) {
        Attribute ignoreAttr = (Attribute)this.alinousAttributes.get("alns:ignoreblank");
        if (ignoreAttr == null) {
            return;
        }
        StringBuffer buff = new StringBuffer();
        buff.append("alns:ignoreblank");
        buff.append(":");
        buff.append(this.getName());
        XMLTagBase.FormHiddenValue hidden = new XMLTagBase.FormHiddenValue(buff.toString(), "true");
        hiddens.add(hidden);
    }

    private void renderValue(PostContext context, Writer wr) throws IOException {
        Attribute attrType = (Attribute)this.attributes.get(ATTR_TYPE);
        Attribute attrValue = (Attribute)this.attributes.get(ATTR_VALUE);
        String type = null;
        if (attrValue == null || attrValue.getValue() == null) {
            return;
        }
        type = attrType == null ? TYPE_TEXT : attrType.getValue().getValue();
        wr.append(" ");
        attrValue.renderContents(wr, 0, this.context, this.valRepo, false);
        if (type.equals(TYPE_RADIO) || type.equals(TYPE_CHECKBOX)) {
            this.renderChecked(context, wr);
        }
    }

    private void renderChecked(PostContext context, Writer wr) throws IOException {
        if (!context.isUseFormCache()) {
            Attribute attrChecked = (Attribute)this.attributes.get(ATTR_CHECKED);
            if (attrChecked != null) {
                IAttributeValue attrVal = attrChecked.getValue();
                String strChecked = null;
                if (attrVal != null) {
                    strChecked = attrVal.getParsedValue(context, this.valRepo);
                }
                if (strChecked == null || !strChecked.toUpperCase().equals("FALSE") && !strChecked.toUpperCase().equals("DISABLED") && !strChecked.toUpperCase().equals("UNCHECKED")) {
                    attrChecked.renderContents(wr, 0, this.context, this.valRepo, false);
                }
            }
            return;
        }
        Attribute attrValue = (Attribute)this.attributes.get(ATTR_VALUE);
        if (attrValue == null) {
            return;
        }
        String selfValue = attrValue.getValue().getParsedValue(context, this.valRepo);
        if (selfValue == null) {
            return;
        }
        FormTagObject base = this.findFormTag();
        if (!(base instanceof FormTagObject)) {
            return;
        }
        FormTagObject formTag = base;
        IParamValue val = this.getCachedValue(context, formTag);
        if (!(val instanceof ArrayParamValue)) {
            this.handleSingle(val, selfValue, wr);
            return;
        }
        ArrayParamValue arrayParam = (ArrayParamValue)val;
        if (arrayParam.containsValue(selfValue)) {
            wr.write(ATTR_CHECKED);
        }
    }

    private void handleSingle(IParamValue val, String selfValue, Writer wr) throws IOException {
        if (val == null) {
            return;
        }
        String strValue = ((StringParamValue)val).getValue();
        if (strValue == null) {
            return;
        }
        if (strValue.equals(selfValue)) {
            wr.write(ATTR_CHECKED);
        }
    }

    private void handleCache(PostContext context) throws ExecutionException {
        FormTagObject formTag = this.findFormTag();
        if (formTag == null) {
            return;
        }
        IParamValue val = this.getCachedValue(context, formTag);
        Attribute attrType = (Attribute)this.attributes.get(ATTR_TYPE);
        if (attrType == null || attrType.getValue() == null) {
            return;
        }
        String type = attrType.getValue().getValue();
        if (val != null && !type.equals(TYPE_RADIO) && !type.equals(TYPE_CHECKBOX)) {
            Attribute attr = new Attribute();
            attr.setKey(ATTR_VALUE);
            attr.setValue(new DqString(((Object)val).toString()));
            if (attr.getValue().getValue() != null) {
                this.attributes.put(ATTR_VALUE, attr);
            }
        }
    }

    private FormTagObject findFormTag() {
        XMLTagBase base = this.getParent();
        while (!(base instanceof AlinousTopObject)) {
            if (base instanceof FormTagObject) {
                return (FormTagObject)base;
            }
            base = base.getParent();
        }
        return null;
    }

    private IParamValue getCachedValue(PostContext context, FormTagObject formTag) {
        String formId = formTag.getFormId();
        FormValues formValues = context.getFormValues();
        HashMap<String, IParamValue> map = formValues.getMap(formId);
        IParamValue val = (IParamValue)map.get(this.getName());
        return val;
    }

    public String getName() {
        Attribute nm = (Attribute)this.attributes.get(ATTR_NAME);
        if (nm != null) {
            return this.removeArrayDesc(nm.getValue().getValue());
        }
        return "";
    }

    private String removeArrayDesc(String nameStr) {
        if (nameStr.endsWith("[]")) {
            return nameStr.substring(0, nameStr.length() - 2);
        }
        return nameStr;
    }

    @Override
    public String getTagName() {
        return "INPUT";
    }

    @Override
    protected boolean isNameNeeded() {
        return true;
    }

    @Override
    protected boolean isValueNeeded() {
        Attribute typeAttr = (Attribute)this.attributes.get(ATTR_TYPE);
        if (typeAttr == null) {
            return false;
        }
        String typeStr = typeAttr.getValue().getValue();
        return typeStr != null && (typeStr.equals(TYPE_CHECKBOX) || typeStr.equals(TYPE_RADIO));
    }
}

