/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.objects.html;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.alinous.exec.pages.PostContext;
import org.alinous.expections.AlinousException;
import org.alinous.expections.ExecutionException;
import org.alinous.objects.Attribute;
import org.alinous.objects.IAlinousObject;
import org.alinous.objects.XMLTagBase;
import org.alinous.objects.html.AlinousTopObject;
import org.alinous.objects.html.IHtmlObject;
import org.alinous.script.runtime.IPathElement;
import org.alinous.script.runtime.IScriptVariable;
import org.alinous.script.runtime.PathElementFactory;
import org.alinous.script.runtime.ScriptDomVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpanTagObject
extends XMLTagBase
implements IHtmlObject {
    @Override
    public IAlinousObject fork() throws AlinousException {
        SpanTagObject newObj = new SpanTagObject();
        this.copyAttribute(this, newObj);
        this.forkInnerObjects(newObj);
        return newObj;
    }

    @Override
    public void renderContents(PostContext context, Writer wr, int n) throws IOException, AlinousException {
        if (!this.handleIf(context)) {
            return;
        }
        if (this.handleValidationMsg(context, wr, n)) {
            return;
        }
        if (this.handleIterateAttribute(context, wr, n)) {
            return;
        }
        this.doRenderContent(context, wr, n);
    }

    @Override
    protected void doRenderContent(PostContext context, Writer wr, int n) throws IOException, AlinousException {
        wr.append("<span");
        this.renderAttributes(wr, 0);
        wr.append(">");
        if (!this.handleInnserTag(context, wr, n)) {
            this.renderInnerContents(context, wr, n + 1);
        }
        wr.append("</span>");
    }

    private boolean handleValidationMsg(PostContext context, Writer wr, int n) throws ExecutionException {
        Attribute attrMsg = (Attribute)this.alinousAttributes.get("alns:msg");
        Attribute attrForm = (Attribute)this.alinousAttributes.get("alns:form");
        Attribute attrValidator = (Attribute)this.alinousAttributes.get("alns:validate");
        if (attrMsg == null || attrMsg.getValue().getValue().equals("")) {
            return false;
        }
        AlinousTopObject topObj = this.getTopObject();
        String strModPath = topObj.getModulePath().getStringPath();
        if (context.getFormLastTargetTagId() != null && !context.getFormLastTargetTagId().equals(strModPath)) {
            return true;
        }
        String msgInput = attrMsg.getValue().getValue();
        String msgForm = null;
        String[] msgValidators = null;
        if (attrForm != null) {
            msgForm = attrForm.getValue().getValue();
        }
        if (attrValidator != null) {
            msgValidators = attrValidator.getValue().getValue().split(",");
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < msgValidators.length; ++i) {
            StringBuffer buff = new StringBuffer();
            buff.append("VALIDATE");
            if (msgForm != null) {
                buff.append(".");
                buff.append(msgForm);
            }
            buff.append(".");
            buff.append(msgInput);
            buff.append(".");
            buff.append(msgValidators[i]);
            list.add(buff.toString());
        }
        boolean bl = this.hitValidator(list, context);
        return !bl;
    }

    private boolean hitValidator(List<String> list, PostContext context) throws ExecutionException {
        for (String path : list) {
            ScriptDomVariable dom;
            IPathElement iPath = PathElementFactory.buildPathElement(path);
            IScriptVariable val = this.valRepo.getVariable(iPath, context);
            if (!(val instanceof ScriptDomVariable) || (dom = (ScriptDomVariable)val).getValue() == null || !dom.getValue().equals("true")) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getTagName() {
        return "SPAN";
    }
}

