/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.plugin.mysql;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import org.alinous.datasrc.exception.DataSourceException;
import org.apache.commons.pool.BasePoolableObjectFactory;

public class MySQLConnectionFactory
extends BasePoolableObjectFactory {
    private Driver driver;
    private String user;
    private String pass;
    private String uri;

    public MySQLConnectionFactory(Driver driver, String user, String pass, String uri) {
        this.driver = driver;
        this.uri = uri;
        this.user = user;
        this.pass = pass;
    }

    public Object makeObject() throws Exception {
        Properties info = new Properties();
        if (this.user != null && !this.user.equals("")) {
            info.put("user", this.user);
        }
        if (this.pass != null && !this.pass.equals("")) {
            info.put("password", this.pass);
        }
        Connection con = null;
        try {
            con = this.driver.connect(this.uri, info);
        }
        catch (SQLException e) {
            throw new DataSourceException(e);
        }
        catch (Throwable e) {
            throw new DataSourceException(e);
        }
        return con;
    }

    public void passivateObject(Object arg0) throws Exception {
        super.passivateObject(arg0);
    }

    public void activateObject(Object arg0) throws Exception {
        super.activateObject(arg0);
    }

    public void destroyObject(Object arg0) throws Exception {
        Connection con = (Connection)arg0;
        try {
            con.close();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            super.destroyObject(arg0);
        }
    }
}

