/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.repository;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.alinous.datasrc.AlinousDataSourceManager;
import org.alinous.datasrc.DataSrcConnection;
import org.alinous.datasrc.exception.DataSourceException;
import org.alinous.datasrc.types.DataTable;
import org.alinous.datasrc.types.Record;
import org.alinous.expections.AlinousException;
import org.alinous.expections.ExecutionException;
import org.alinous.repository.SystemRepositoryConfig;
import org.alinous.script.sql.FromClause;
import org.alinous.script.sql.OrderByClause;
import org.alinous.script.sql.SelectColumns;
import org.alinous.script.sql.WhereClause;
import org.alinous.script.sql.condition.AndExpression;
import org.alinous.script.sql.condition.TwoClauseExpression;
import org.alinous.script.sql.other.ColumnList;
import org.alinous.script.sql.other.SelectColumnElement;
import org.alinous.script.sql.other.TableIdentifier;
import org.alinous.script.sql.other.TablesList;
import org.alinous.script.sql.statement.Identifier;
import org.alinous.script.sql.statement.SQLStringConst;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlinousSystemRepository {
    public static final int HASH_VALUE = 2;
    public static final String VALUES_TABLE = "ALINOUS_VALUES";
    public static final String SESSION_ID = "SESSION_ID";
    public static final String MODULE_PATH = "MODULE_PATH";
    public static final String FILE_PATH = "FILE_PATH";
    public static final String NAME_PATH = "NAME_PATH";
    public static final String TYPE = "TYPE";
    public static final String VALUE_TYPE = "VALUE_TYPE";
    public static final String VALUE = "VALUE";
    public static final String CREATE_TIME = "CREATE_TIME";
    public static final String LAST_FILE_PATH = "LAST_FILE_PATH";
    public static final String FORM_VALUS_TABLE = "ALINOUS_FORM_VALUES";
    public static final String FORM_ID = "FORM_ID";
    public static final String VARIABLE_NAME = "VARIABLE_NAME";
    public static final String INNER_STATUS_TABLE = "ALINOUS_INNER_STATUS";
    public static final String BACKING_STATUS_TABLE = "ALINOUS_BACKING_STATUS";
    public static final String SESSION_TABLE = "ALINOUS_SESSION_TABLE";
    private SystemRepositoryConfig config;
    private AlinousDataSourceManager dataSourceManager;

    public AlinousSystemRepository(AlinousDataSourceManager dataSourceManager) {
        this.dataSourceManager = dataSourceManager;
    }

    public void install(SystemRepositoryConfig config) throws AlinousException {
        this.config = config;
        String dataSourceId = this.config.getSystemSrc();
        DataSrcConnection con = null;
        try {
            con = this.dataSourceManager.connect(dataSourceId);
        }
        catch (DataSourceException e) {
            throw new AlinousException(e, "Failed to connect");
        }
        this.initValueCacheTable(con);
        this.initFormValueInfoTable(con);
        this.initInnerStatusTable(con);
        this.initBackingStatusTable(con);
        this.initSessionTable(con);
        con.close();
    }

    private void initSessionTable(DataSrcConnection con) throws AlinousException {
        DataTable dataTable = null;
        try {
            dataTable = con.getDataTable(SESSION_TABLE);
        }
        catch (DataSourceException e) {
            con.close();
            throw new AlinousException(e, "Failed to get Metadata");
        }
        if (dataTable == null) {
            dataTable = new DataTable(SESSION_TABLE);
            dataTable.addField(SESSION_ID, "String", true, 128);
            dataTable.addField(VARIABLE_NAME, "String", true, 255);
            dataTable.addField(TYPE, "String");
            dataTable.addField(VALUE_TYPE, "String");
            dataTable.addField(VALUE, "TEXT");
            dataTable.addField(CREATE_TIME, "Timestamp");
            try {
                con.createTable(dataTable);
            }
            catch (DataSourceException e) {
                con.close();
                throw new AlinousException(e, "Failed to CREATE TABLE ALINOUS_SESSION_TABLE");
            }
        }
    }

    private void initBackingStatusTable(DataSrcConnection con) throws AlinousException {
        DataTable dataTable = null;
        try {
            dataTable = con.getDataTable(BACKING_STATUS_TABLE);
        }
        catch (DataSourceException e) {
            con.close();
            throw new AlinousException(e, "Failed to get Metadata");
        }
        if (dataTable == null) {
            dataTable = new DataTable(BACKING_STATUS_TABLE);
            dataTable.addField(SESSION_ID, "String", true, 128);
            dataTable.addField(MODULE_PATH, "TEXT", true, 255);
            dataTable.addField(FILE_PATH, "TEXT", true, 255);
            dataTable.addField(LAST_FILE_PATH, "TEXT");
            dataTable.addField(CREATE_TIME, "Timestamp");
            try {
                con.createTable(dataTable);
            }
            catch (DataSourceException e) {
                con.close();
                throw new AlinousException(e, "Failed to CREATE TABLE ALINOUS_BACKING_STATUS");
            }
        }
    }

    private void initInnerStatusTable(DataSrcConnection con) throws AlinousException {
        DataTable dataTable = null;
        try {
            dataTable = con.getDataTable(INNER_STATUS_TABLE);
        }
        catch (DataSourceException e) {
            con.close();
            throw new AlinousException(e, "Failed to get Metadata");
        }
        if (dataTable == null) {
            dataTable = new DataTable(INNER_STATUS_TABLE);
            dataTable.addField(SESSION_ID, "String", true, 128);
            dataTable.addField(MODULE_PATH, "String", true, 255);
            dataTable.addField(FILE_PATH, "String");
            dataTable.addField(CREATE_TIME, "Timestamp");
            try {
                con.createTable(dataTable);
            }
            catch (DataSourceException e) {
                con.close();
                throw new AlinousException(e, "Failed to CREATE TABLE ALINOUS_INNER_STATUS");
            }
        }
    }

    private void initFormValueInfoTable(DataSrcConnection con) throws AlinousException {
        DataTable dataTable = null;
        try {
            dataTable = con.getDataTable(FORM_VALUS_TABLE);
        }
        catch (DataSourceException e) {
            con.close();
            throw new AlinousException(e, "Failed to get Metadata");
        }
        if (dataTable == null) {
            dataTable = new DataTable(FORM_VALUS_TABLE);
            dataTable.addField(SESSION_ID, "String", true, 128);
            dataTable.addField(MODULE_PATH, "TEXT", true, 255);
            dataTable.addField(FILE_PATH, "String", true, 255);
            dataTable.addField(FORM_ID, "String", true, 32);
            dataTable.addField(VARIABLE_NAME, "String", true, 94);
            dataTable.addField(VALUE_TYPE, "String");
            dataTable.addField(VALUE, "TEXT");
            dataTable.addField(CREATE_TIME, "Timestamp");
            try {
                con.createTable(dataTable);
            }
            catch (DataSourceException e) {
                con.close();
                throw new AlinousException(e, "Failed to CREATE TABLE ALINOUS_FORM_VALUES");
            }
        }
    }

    private void initValueCacheTable(DataSrcConnection con) throws AlinousException {
        DataTable dataTable = null;
        try {
            dataTable = con.getDataTable(VALUES_TABLE);
        }
        catch (DataSourceException e) {
            con.close();
            throw new AlinousException(e, "Failed to get Metadata");
        }
        if (dataTable == null) {
            dataTable = new DataTable(VALUES_TABLE);
            dataTable.addField(SESSION_ID, "String", true, 128);
            dataTable.addField(MODULE_PATH, "TEXT", true, 255);
            dataTable.addField(FILE_PATH, "String", true, 128);
            dataTable.addField(NAME_PATH, "String", true, 128);
            dataTable.addField(TYPE, "String");
            dataTable.addField(VALUE_TYPE, "String");
            dataTable.addField(VALUE, "TEXT");
            dataTable.addField(CREATE_TIME, "Timestamp");
            try {
                con.createTable(dataTable);
            }
            catch (DataSourceException e) {
                con.close();
                throw new AlinousException(e, "Failed to CREATE TABLE ALINOUS_VALUES");
            }
        }
    }

    public List<Record> selectRecord(String tableName, Map<String, String> queryParams) throws DataSourceException, ExecutionException {
        List<Record> recordList = null;
        DataSrcConnection con = this.dataSourceManager.connect(this.config.getSystemSrc());
        con.setOutSql(false);
        FromClause from = new FromClause();
        TablesList tableList = new TablesList();
        TableIdentifier table = new TableIdentifier();
        table.setTableName(tableName);
        tableList.addTable(table);
        from.setTableList(tableList);
        OrderByClause orderBy = new OrderByClause();
        ColumnList orderColumns = new ColumnList();
        SelectColumnElement columnIdentifier = new SelectColumnElement();
        columnIdentifier.setColumnName(CREATE_TIME);
        orderColumns.addColumns(columnIdentifier);
        orderBy.setColumnList(orderColumns);
        SelectColumns columns = new SelectColumns();
        WhereClause where = this.createWhereClauseFromParamMap(queryParams);
        try {
            recordList = con.select(null, columns, from, where, null, orderBy, null, null);
        }
        catch (DataSourceException e) {
            throw e;
        }
        catch (ExecutionException e) {
            throw e;
        }
        finally {
            con.setOutSql(true);
            con.close();
        }
        return recordList;
    }

    private WhereClause createWhereClauseFromParamMap(Map<String, String> queryParams) {
        WhereClause where = new WhereClause();
        AndExpression andExp = new AndExpression();
        for (String field : queryParams.keySet()) {
            String val = queryParams.get(field);
            Identifier id = new Identifier();
            id.setName(field);
            SQLStringConst sqVal = new SQLStringConst();
            sqVal.setStr(val);
            TwoClauseExpression eqExp = new TwoClauseExpression();
            eqExp.setOpe("=");
            eqExp.setLeft(id);
            eqExp.setRight(sqVal);
            andExp.addExpressions(eqExp);
        }
        where.setExpression(andExp);
        return where;
    }

    public void insertRecord(DataSrcConnection con, String tableName, List<Record> records) throws DataSourceException {
        con.insert(records, tableName);
    }

    public DataSrcConnection getConnection() throws DataSourceException {
        DataSrcConnection con = this.dataSourceManager.connect(this.config.getSystemSrc());
        con.setOutSql(false);
        return con;
    }

    public void closeConnection(DataSrcConnection con) {
        con.setOutSql(true);
        con.close();
    }

    public void deleteRecord(DataSrcConnection con, String tableName, Map<String, String> queryParams) throws DataSourceException, ExecutionException {
        FromClause from = new FromClause();
        TablesList tableList = new TablesList();
        TableIdentifier table = new TableIdentifier();
        table.setTableName(tableName);
        tableList.addTable(table);
        from.setTableList(tableList);
        WhereClause where = this.createWhereClauseFromParamMap(queryParams);
        try {
            con.delete(from.extract(), where);
        }
        catch (DataSourceException e) {
            throw e;
        }
        catch (ExecutionException e) {
            throw e;
        }
    }

    public void selectForUpdateRecord(String tableName, Map<String, String> queryParams) throws DataSourceException, ExecutionException {
        DataSrcConnection con = this.dataSourceManager.connect(this.config.getSystemSrc());
        con.setOutSql(false);
        FromClause from = new FromClause();
        TablesList tableList = new TablesList();
        TableIdentifier table = new TableIdentifier();
        table.setTableName(tableName);
        tableList.addTable(table);
        from.setTableList(tableList);
        OrderByClause orderBy = new OrderByClause();
        ColumnList orderColumns = new ColumnList();
        SelectColumnElement columnIdentifier = new SelectColumnElement();
        columnIdentifier.setColumnName(CREATE_TIME);
        orderColumns.addColumns(columnIdentifier);
        orderBy.setColumnList(orderColumns);
        SelectColumns columns = new SelectColumns();
        WhereClause where = this.createWhereClauseFromParamMap(queryParams);
        try {
            con.select(null, columns, from, where, null, orderBy, null, null);
        }
        catch (DataSourceException e) {
            throw e;
        }
        catch (ExecutionException e) {
            throw e;
        }
        finally {
            con.setOutSql(true);
            con.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanOldSessionData() throws DataSourceException, ExecutionException {
        long time = System.currentTimeMillis();
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(time);
        cal.add(10, -6);
        DataSrcConnection con = null;
        try {
            con = this.getConnection();
            con.setOutSql(true);
            String timeStr = new Timestamp(cal.getTimeInMillis()).toString();
            this.deleteOld4Table(VALUES_TABLE, timeStr, con);
            this.deleteOld4Table(FORM_VALUS_TABLE, timeStr, con);
            this.deleteOld4Table(INNER_STATUS_TABLE, timeStr, con);
            this.deleteOld4Table(BACKING_STATUS_TABLE, timeStr, con);
            this.deleteOld4Table(SESSION_TABLE, timeStr, con);
        }
        finally {
            if (con != null) {
                con.close();
            }
        }
    }

    private void deleteOld4Table(String tableName, String timeStamp, DataSrcConnection con) throws ExecutionException, DataSourceException {
        WhereClause whereClause = this.buildWhere(timeStamp);
        FromClause from = this.buildFrom(tableName);
        con.delete(from.extract(), whereClause);
    }

    private FromClause buildFrom(String tableName) {
        FromClause from = new FromClause();
        TablesList tableList = new TablesList();
        TableIdentifier table = new TableIdentifier();
        table.setTableName(tableName);
        tableList.addTable(table);
        from.setTableList(tableList);
        return from;
    }

    private WhereClause buildWhere(String timeStamp) {
        WhereClause whereClause = new WhereClause();
        Identifier id = new Identifier();
        id.setName(CREATE_TIME);
        SQLStringConst sqVal = new SQLStringConst();
        sqVal.setStr(timeStamp);
        TwoClauseExpression eqExp = new TwoClauseExpression();
        eqExp.setOpe("<");
        eqExp.setLeft(id);
        eqExp.setRight(sqVal);
        whereClause.setExpression(eqExp);
        return whereClause;
    }
}

