/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.script.attribute;

import java.util.ArrayList;
import java.util.List;
import org.alinous.exec.pages.PostContext;
import org.alinous.expections.ExecutionException;
import org.alinous.script.IScriptObject;
import org.alinous.script.basic.condition.IScriptCondition;
import org.alinous.script.basic.type.IStatement;
import org.alinous.script.basic.type.VariableDescriptor;
import org.alinous.script.runtime.IPathElement;
import org.alinous.script.runtime.IScriptVariable;
import org.alinous.script.runtime.ScriptDomVariable;
import org.alinous.script.runtime.VariableRepository;

public class ParsedAttribute {
    private List<IScriptObject> elements = new ArrayList<IScriptObject>();

    public void addElement(IScriptObject element) {
        this.elements.add(element);
    }

    public IPathElement getPathElement() {
        if (this.elements.size() <= 0) {
            return null;
        }
        if (!(this.elements.get(0) instanceof VariableDescriptor)) {
            return null;
        }
        return ((VariableDescriptor)this.elements.get(0)).getPath();
    }

    public String expand(PostContext context, VariableRepository valRepo) throws ExecutionException {
        StringBuffer buffer = new StringBuffer();
        for (IScriptObject obj : this.elements) {
            if (!(obj instanceof IStatement)) {
                throw new ExecutionException("Cannot use condition here.");
            }
            IStatement stmt = (IStatement)obj;
            PostContext dummyContext = new PostContext(context.getCore(), context.getUnit());
            IScriptVariable value = stmt.executeStatement(dummyContext, valRepo);
            if (!(value instanceof ScriptDomVariable)) {
                throw new ExecutionException("Cannot use array here.");
            }
            buffer.append(((ScriptDomVariable)value).getValue());
            dummyContext.handleReservedOperations(valRepo);
        }
        return buffer.toString();
    }

    public boolean evaluate(PostContext context, VariableRepository valRepo) throws ExecutionException {
        if (this.elements.size() != 1) {
            throw new ExecutionException("Cannot evaluate multiple conditions.");
        }
        if (!(this.elements.get(0) instanceof IScriptCondition)) {
            throw new ExecutionException("Please input a condition.");
        }
        IScriptCondition cond = (IScriptCondition)this.elements.get(0);
        return cond.evaluate(context, valRepo);
    }
}

