/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.script.basic;

import java.util.LinkedList;
import java.util.List;
import org.alinous.AlinousConfig;
import org.alinous.AlinousCore;
import org.alinous.datasrc.AlinousDataSourceManager;
import org.alinous.debug.DebugThread;
import org.alinous.debug.StepInCandidates;
import org.alinous.exec.IExecutable;
import org.alinous.exec.pages.PostContext;
import org.alinous.expections.ExecutionException;
import org.alinous.script.ISQLSentence;
import org.alinous.script.IScriptBlock;
import org.alinous.script.IScriptSentence;
import org.alinous.script.basic.DoWhileBlock;
import org.alinous.script.basic.ReturnSentence;
import org.alinous.script.basic.UseSentence;
import org.alinous.script.functions.FunctionDeclaration;
import org.alinous.script.runtime.IScriptVariable;
import org.alinous.script.runtime.VariableRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractScriptBlock
implements IScriptBlock {
    protected List<IScriptSentence> sentences = new LinkedList<IScriptSentence>();
    protected String filePath;
    protected int line;
    protected int linePosition;
    protected AlinousDataSourceManager dataSourceManager;
    protected String curDataSource;
    protected AlinousConfig config;
    protected IScriptVariable returnedVariable;

    protected boolean executeSentence(IScriptSentence exec, PostContext context, VariableRepository valRepo) throws ExecutionException {
        if (AlinousCore.debug && !(exec instanceof DoWhileBlock)) {
            DebugThread thread = context.getCore().getAlinousDebugManager().getCurrentThread();
            thread.getTopStackFrame().resetExecutedCandidate();
            StepInCandidates ca = exec.getStepInCandidates();
            thread.getTopStackFrame().setCurrentCandidate(ca);
            context.getCore().getAlinousDebugManager().aboutToExecuteSentence(this, exec);
        }
        boolean blResult = true;
        if (exec instanceof ISQLSentence) {
            blResult = this.executeSQLSentence(exec, context, valRepo);
        } else if (exec instanceof UseSentence) {
            UseSentence useSentence = (UseSentence)exec;
            this.curDataSource = useSentence.getDataSource();
        } else if (exec instanceof AbstractScriptBlock) {
            AbstractScriptBlock block = (AbstractScriptBlock)exec;
            block.setConfig(this.config);
            block.setDataSourceManager(this.dataSourceManager);
            block.setCurrentDataSource(this.curDataSource);
            blResult = block.execute(context, valRepo);
            if (!(exec instanceof FunctionDeclaration)) {
                this.returnedVariable = exec.getReturnedVariable();
            }
        } else if (exec instanceof ReturnSentence) {
            blResult = false;
            exec.execute(context, valRepo);
            this.returnedVariable = ((ReturnSentence)exec).getReturnedValue();
        } else {
            blResult = exec.execute(context, valRepo);
        }
        context.handleReservedOperations(valRepo);
        if (AlinousCore.debug) {
            DebugThread thread = context.getCore().getAlinousDebugManager().getCurrentThread();
            thread.getTopStackFrame().setCurrentCandidate(null);
        }
        return blResult;
    }

    private boolean executeSQLSentence(IExecutable exec, PostContext context, VariableRepository valRepo) throws ExecutionException {
        ISQLSentence sqlSentence = (ISQLSentence)exec;
        sqlSentence.setConfig(this.config);
        sqlSentence.setDefaultDataSource(this.curDataSource);
        return sqlSentence.execute(context, valRepo);
    }

    public void setConfig(AlinousConfig config) {
        this.config = config;
    }

    public void setDataSourceManager(AlinousDataSourceManager dataSourceManager) {
        this.dataSourceManager = dataSourceManager;
    }

    public void setCurrentDataSource(String dataSource) {
        this.curDataSource = dataSource;
    }

    @Override
    public void addSentence(IScriptSentence sentence) {
        this.sentences.add(sentence);
        sentence.setFilePath(this.filePath);
    }

    @Override
    public String getFilePath() {
        return this.filePath;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public void setLine(int line) {
        this.line = line;
    }

    @Override
    public int getLinePosition() {
        return this.linePosition;
    }

    @Override
    public void setLinePosition(int linePosition) {
        this.linePosition = linePosition;
    }

    @Override
    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    @Override
    public IScriptVariable getReturnedVariable() {
        return this.returnedVariable;
    }

    public List<IScriptSentence> getSentences() {
        return this.sentences;
    }
}

