/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.script.basic;

import org.alinous.AlinousCore;
import org.alinous.debug.StepInCandidates;
import org.alinous.exec.pages.PostContext;
import org.alinous.expections.AlinousException;
import org.alinous.expections.ExecutionException;
import org.alinous.script.IScriptSentence;
import org.alinous.script.basic.AbstractScriptBlock;
import org.alinous.script.basic.BreakSentence;
import org.alinous.script.basic.ContinueSentence;
import org.alinous.script.basic.DummyConditionSentence;
import org.alinous.script.basic.condition.IScriptCondition;
import org.alinous.script.basic.condition.JDomConditionFactory;
import org.alinous.script.runtime.VariableRepository;
import org.jdom.Content;
import org.jdom.Element;

public class ForBlock
extends AbstractScriptBlock {
    public static final String BLOCK_NAME = "ForBlock";
    private IScriptSentence initSentence;
    private IScriptSentence afterLoop;
    private IScriptCondition condition;

    public String getName() {
        return BLOCK_NAME;
    }

    public boolean execute(PostContext context, VariableRepository valRepo) throws ExecutionException {
        this.executeSentence(this.initSentence, context, valRepo);
        boolean condResult = this.condition.evaluate(context, valRepo);
        if (!condResult) {
            return true;
        }
        while (condResult) {
            for (IScriptSentence exec : this.sentences) {
                boolean res = this.executeSentence(exec, context, valRepo);
                if (!res) {
                    return false;
                }
                if (exec instanceof BreakSentence) {
                    return true;
                }
                if (!(exec instanceof ContinueSentence)) continue;
                break;
            }
            this.executeSentence(this.afterLoop, context, valRepo);
            if (AlinousCore.debug) {
                DummyConditionSentence dummyExec = new DummyConditionSentence(this);
                dummyExec.setCondition(this.condition);
                context.getCore().getAlinousDebugManager().aboutToExecuteSentence(this, dummyExec);
            }
            if (condResult = this.condition.evaluate(context, valRepo)) continue;
            return true;
        }
        return true;
    }

    public void exportIntoJDomElement(Element parent) throws AlinousException {
        Element forElement = new Element("EXECUTABLE");
        forElement.setAttribute("execClass", this.getClass().getName());
        parent.addContent((Content)forElement);
        this.condition.exportIntoJDomElement(forElement);
    }

    public void importFromJDomElement(Element element) throws AlinousException {
        Element cond = element.getChild("CONDITION");
        this.condition = JDomConditionFactory.createConditionFromJDomElement(cond);
        this.condition.importFromJDomElement(cond);
    }

    public IScriptSentence getAfterLoop() {
        return this.afterLoop;
    }

    public void setAfterLoop(IScriptSentence afterLoop) {
        afterLoop.setFilePath(this.filePath);
        afterLoop.setLine(this.line);
        afterLoop.setLinePosition(this.linePosition);
        this.afterLoop = afterLoop;
    }

    public IScriptCondition getCondition() {
        return this.condition;
    }

    public void setCondition(IScriptCondition condition) {
        condition.setCallerSentence(this);
        this.condition = condition;
    }

    public IScriptSentence getInitSentence() {
        return this.initSentence;
    }

    public void setInitSentence(IScriptSentence initSentence) {
        this.initSentence = initSentence;
        initSentence.setFilePath(this.filePath);
        initSentence.setLine(this.line);
        initSentence.setLinePosition(this.linePosition);
    }

    public StepInCandidates getStepInCandidates() {
        StepInCandidates candidates = new StepInCandidates();
        this.condition.canStepInStatements(candidates);
        return candidates;
    }
}

