/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.script.basic;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.alinous.debug.StepInCandidates;
import org.alinous.exec.pages.PostContext;
import org.alinous.expections.AlinousException;
import org.alinous.expections.ExecutionException;
import org.alinous.script.IScriptSentence;
import org.alinous.script.basic.AbstractScriptBlock;
import org.alinous.script.basic.ElseBlock;
import org.alinous.script.basic.condition.IScriptCondition;
import org.alinous.script.basic.condition.JDomConditionFactory;
import org.alinous.script.runtime.VariableRepository;
import org.jdom.Content;
import org.jdom.Element;

public class IfBlock
extends AbstractScriptBlock {
    public static final String BLOCK_NAME = "IfBlock";
    private IScriptCondition condition;
    private boolean condResult;
    private List<ElseBlock> elseBlockList = new ArrayList<ElseBlock>();

    public boolean execute(PostContext context, VariableRepository valRepo) throws ExecutionException {
        this.condition.setCallerSentence(this);
        this.condResult = this.condition.evaluate(context, valRepo);
        if (!this.condResult) {
            return this.handleElse(context, valRepo);
        }
        for (IScriptSentence exec : this.sentences) {
            boolean blRes = this.executeSentence(exec, context, valRepo);
            if (blRes) continue;
            return false;
        }
        return true;
    }

    private boolean handleElse(PostContext context, VariableRepository valRepo) throws ExecutionException {
        Iterator<ElseBlock> it = this.elseBlockList.iterator();
        boolean result = true;
        while (it.hasNext()) {
            ElseBlock elseBlk = it.next();
            result = this.executeSentence(elseBlk, context, valRepo);
            if (!elseBlk.isCondResult()) continue;
            break;
        }
        return result;
    }

    public IScriptCondition getCondition() {
        return this.condition;
    }

    public void setCondition(IScriptCondition condition) {
        condition.setCallerSentence(this);
        this.condition = condition;
    }

    public void exportIntoJDomElement(Element parent) throws AlinousException {
        Element selectElement = new Element("EXECUTABLE");
        selectElement.setAttribute("execClass", this.getClass().getName());
        parent.addContent((Content)selectElement);
        this.condition.exportIntoJDomElement(selectElement);
    }

    public void importFromJDomElement(Element element) throws AlinousException {
        Element cond = element.getChild("CONDITION");
        this.condition = JDomConditionFactory.createConditionFromJDomElement(cond);
        this.condition.importFromJDomElement(cond);
    }

    public String getName() {
        return BLOCK_NAME;
    }

    public boolean isCondResult() {
        return this.condResult;
    }

    public StepInCandidates getStepInCandidates() {
        StepInCandidates candidates = new StepInCandidates();
        this.condition.canStepInStatements(candidates);
        return candidates;
    }

    public void addElseBlock(ElseBlock elseBlock) {
        this.elseBlockList.add(elseBlock);
    }
}

