/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.script.basic.condition;

import java.util.List;
import org.alinous.debug.StepInCandidates;
import org.alinous.exec.pages.PostContext;
import org.alinous.expections.AlinousException;
import org.alinous.expections.ExecutionException;
import org.alinous.script.IScriptSentence;
import org.alinous.script.basic.condition.IScriptCondition;
import org.alinous.script.basic.condition.JDomConditionFactory;
import org.alinous.script.basic.type.IStatement;
import org.alinous.script.runtime.IScriptVariable;
import org.alinous.script.runtime.ScriptDomVariable;
import org.alinous.script.runtime.VariableRepository;
import org.jdom.Content;
import org.jdom.Element;

public class DirectCondition
implements IScriptCondition {
    public static final String ATTR_OPE = "ope";
    public static String OPE_CMP_EQUALS = "==";
    public static String OPE_CMP_NOTEQUALS = "!=";
    public static String OPE_GT = ">";
    public static String OPE_GEQ = ">=";
    public static String OPE_LT = "<";
    public static String OPE_LEQ = "<=";
    private IScriptCondition left;
    private IScriptCondition right;
    private String ope;
    private IScriptSentence callerSentence;
    private int line;
    private int linePosition;

    public boolean evaluate(PostContext context, VariableRepository valRepo) throws ExecutionException {
        if (!(this.left instanceof IStatement)) {
            throw new ExecutionException(this.ope + " cannot have condition operand");
        }
        if (!(this.right instanceof IStatement)) {
            throw new ExecutionException(this.ope + " cannot have condition operand");
        }
        IScriptVariable leftValue = ((IStatement)((Object)this.left)).executeStatement(context, valRepo);
        IScriptVariable rightValue = ((IStatement)((Object)this.right)).executeStatement(context, valRepo);
        if (!(leftValue instanceof ScriptDomVariable)) {
            throw new ExecutionException("Left value must be a variable");
        }
        if (!(rightValue instanceof ScriptDomVariable)) {
            throw new ExecutionException("Right value must be a variable");
        }
        if (OPE_CMP_EQUALS.equals(this.ope)) {
            return this.checkEquals((ScriptDomVariable)leftValue, (ScriptDomVariable)rightValue);
        }
        if (OPE_CMP_NOTEQUALS.equals(this.ope)) {
            return !this.checkEquals((ScriptDomVariable)leftValue, (ScriptDomVariable)rightValue);
        }
        if (OPE_GT.equals(this.ope)) {
            return this.checkGt((ScriptDomVariable)leftValue, (ScriptDomVariable)rightValue);
        }
        if (OPE_GEQ.equals(this.ope)) {
            return this.checkGtEq((ScriptDomVariable)leftValue, (ScriptDomVariable)rightValue);
        }
        if (OPE_LT.equals(this.ope)) {
            return this.checkLt((ScriptDomVariable)leftValue, (ScriptDomVariable)rightValue);
        }
        if (OPE_LEQ.equals(this.ope)) {
            return this.checkLtEq((ScriptDomVariable)leftValue, (ScriptDomVariable)rightValue);
        }
        return false;
    }

    private boolean checkLtEq(ScriptDomVariable leftValue, ScriptDomVariable rightValue) throws ExecutionException {
        if (leftValue.getValue() == null || rightValue.getValue() == null) {
            throw new ExecutionException("Nullpointer Exception");
        }
        if (leftValue.getValueType().equals("NUMBER") && rightValue.getValueType().equals("NUMBER")) {
            return Integer.parseInt(leftValue.getValue()) <= Integer.parseInt(rightValue.getValue());
        }
        if (leftValue.getValueType().equals("DOUBLE") || rightValue.getValueType().equals("DOUBLE")) {
            return Double.parseDouble(leftValue.getValue()) <= Double.parseDouble(rightValue.getValue());
        }
        int com = leftValue.getValue().compareTo(rightValue.getValue());
        return com <= 0;
    }

    private boolean checkLt(ScriptDomVariable leftValue, ScriptDomVariable rightValue) throws ExecutionException {
        if (leftValue.getValue() == null || rightValue.getValue() == null) {
            throw new ExecutionException("Nullpointer Exception");
        }
        if (leftValue.getValueType().equals("NUMBER") && rightValue.getValueType().equals("NUMBER")) {
            return Integer.parseInt(leftValue.getValue()) < Integer.parseInt(rightValue.getValue());
        }
        if (leftValue.getValueType().equals("DOUBLE") || rightValue.getValueType().equals("DOUBLE")) {
            return Double.parseDouble(leftValue.getValue()) < Double.parseDouble(rightValue.getValue());
        }
        int com = leftValue.getValue().compareTo(rightValue.getValue());
        return com < 0;
    }

    private boolean checkGtEq(ScriptDomVariable leftValue, ScriptDomVariable rightValue) throws ExecutionException {
        if (leftValue.getValue() == null || rightValue.getValue() == null) {
            throw new ExecutionException("Nullpointer Exception");
        }
        if (leftValue.getValueType().equals("NUMBER") && rightValue.getValueType().equals("NUMBER")) {
            return Integer.parseInt(leftValue.getValue()) >= Integer.parseInt(rightValue.getValue());
        }
        if (leftValue.getValueType().equals("DOUBLE") || rightValue.getValueType().equals("DOUBLE")) {
            return Double.parseDouble(leftValue.getValue()) >= Double.parseDouble(rightValue.getValue());
        }
        int com = leftValue.getValue().compareTo(rightValue.getValue());
        return com >= 0;
    }

    private boolean checkGt(ScriptDomVariable leftValue, ScriptDomVariable rightValue) throws ExecutionException {
        if (leftValue.getValue() == null || rightValue.getValue() == null) {
            throw new ExecutionException("Nullpointer Exception");
        }
        if (leftValue.getValueType().equals("NUMBER") && rightValue.getValueType().equals("NUMBER")) {
            return Integer.parseInt(leftValue.getValue()) > Integer.parseInt(rightValue.getValue());
        }
        if (leftValue.getValueType().equals("DOUBLE") || rightValue.getValueType().equals("DOUBLE")) {
            return Double.parseDouble(leftValue.getValue()) > Double.parseDouble(rightValue.getValue());
        }
        int com = leftValue.getValue().compareTo(rightValue.getValue());
        return com > 0;
    }

    private boolean checkEquals(ScriptDomVariable leftValue, ScriptDomVariable rightValue) {
        if (leftValue.getValue() == null) {
            return rightValue.getValue() == null || rightValue.getValueType().equals("NULL");
        }
        if (leftValue.getValueType().equals("NULL")) {
            return rightValue.getValue() == null || rightValue.getValueType().equals("NULL");
        }
        return leftValue.getValue().equals(rightValue.getValue());
    }

    public IScriptCondition getLeft() {
        return this.left;
    }

    public void setLeft(IScriptCondition left) {
        left.setCallerSentence(this.callerSentence);
        this.left = left;
    }

    public String getOpe() {
        return this.ope;
    }

    public void setOpe(String ope) {
        this.ope = ope;
    }

    public IScriptCondition getRight() {
        return this.right;
    }

    public void setRight(IScriptCondition right) {
        right.setCallerSentence(this.callerSentence);
        this.right = right;
    }

    public void exportIntoJDomElement(Element parent) throws AlinousException {
        Element element = new Element("CONDITION");
        element.setAttribute("condClass", this.getClass().getName());
        element.setAttribute(ATTR_OPE, this.ope);
        parent.setContent((Content)element);
        this.left.exportIntoJDomElement(element);
        this.right.exportIntoJDomElement(element);
    }

    public void importFromJDomElement(Element element) throws AlinousException {
        this.ope = element.getAttributeValue(ATTR_OPE);
        List list = element.getChildren("CONDITION");
        Element lElement = (Element)list.get(0);
        this.left = JDomConditionFactory.createConditionFromJDomElement(lElement);
        this.left.importFromJDomElement(lElement);
        Element rElement = (Element)list.get(1);
        this.right = JDomConditionFactory.createConditionFromJDomElement(rElement);
        this.right.importFromJDomElement(rElement);
    }

    public void canStepInStatements(StepInCandidates candidates) {
        this.left.canStepInStatements(candidates);
        this.right.canStepInStatements(candidates);
    }

    public void setCallerSentence(IScriptSentence callerSentence) {
        this.callerSentence = callerSentence;
        this.right.setCallerSentence(callerSentence);
        this.left.setCallerSentence(callerSentence);
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public int getLinePosition() {
        return this.linePosition;
    }

    public void setLinePosition(int linePosition) {
        this.linePosition = linePosition;
    }
}

