/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.script.functions.system;

import java.util.Stack;
import org.alinous.AlinousCore;
import org.alinous.exec.pages.PostContext;
import org.alinous.expections.ExecutionException;
import org.alinous.script.IScriptSentence;
import org.alinous.script.basic.type.IStatement;
import org.alinous.script.functions.ArgumentDeclare;
import org.alinous.script.functions.ArgumentsDeclare;
import org.alinous.script.functions.IFunction;
import org.alinous.script.runtime.IScriptVariable;
import org.alinous.script.runtime.ScriptArray;
import org.alinous.script.runtime.ScriptDomVariable;
import org.alinous.script.runtime.VariableRepository;
import org.alinous.script.statement.FunctionCall;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSystemFunction
implements IFunction {
    protected Stack<IStatement> stmtStack;
    protected ArgumentsDeclare argmentsDeclare = new ArgumentsDeclare();
    private IScriptSentence callerSentence;

    @Override
    public void inputArguments(Stack<IStatement> stmtStack) {
        this.stmtStack = stmtStack;
    }

    @Override
    public ArgumentsDeclare getArguments() {
        return this.argmentsDeclare;
    }

    protected void handleArguments(PostContext context, VariableRepository valRepoOld, VariableRepository valRepo) throws ExecutionException {
        if (this.stmtStack == null && this.argmentsDeclare != null && this.argmentsDeclare.getSize() == 0) {
            return;
        }
        if (this.stmtStack == null && this.argmentsDeclare != null) {
            throw new ExecutionException("Number of the function is wrong.");
        }
        if (this.stmtStack != null && this.argmentsDeclare == null) {
            throw new ExecutionException("Number of the function is wrong.");
        }
        if (this.stmtStack == null && this.argmentsDeclare == null) {
            return;
        }
        if (this.stmtStack.size() != this.argmentsDeclare.getSize()) {
            throw new ExecutionException("Number of the function is wrong.");
        }
        int size = this.argmentsDeclare.getSize();
        for (int i = 0; i < size; ++i) {
            ArgumentDeclare dec;
            IStatement stmt = (IStatement)this.stmtStack.get(i);
            if (stmt instanceof FunctionCall) {
                ((FunctionCall)stmt).setCallerSentence(this.callerSentence);
            }
            IScriptVariable val = stmt.executeStatement(context, valRepoOld);
            if (AlinousCore.debug) {
                context.getCore().getAlinousDebugManager().afterExecutedFunctionArgumentStatement(this.callerSentence);
            }
            if ((dec = this.argmentsDeclare.get(i)).getPrefix().equals("$")) {
                if (!(val instanceof ScriptDomVariable)) {
                    throw new ExecutionException("Argument " + i + " must be DomVariable.");
                }
            } else if (dec.getPrefix().equals("@")) {
                if (!(val instanceof ScriptArray)) {
                    throw new ExecutionException("Argument " + i + " must be Array.");
                }
            } else {
                throw new ExecutionException("Argument " + i + " has no prefix.");
            }
            val.setName(dec.getName());
            valRepo.putValue(val);
        }
    }

    @Override
    public void setCallerSentence(IScriptSentence callerSentence) {
        this.callerSentence = callerSentence;
    }
}

