/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.script.functions.system;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.alinous.AlinousCore;
import org.alinous.exec.pages.PostContext;
import org.alinous.expections.AlinousException;
import org.alinous.expections.ExecutionException;
import org.alinous.net.mail.AlinousMailConfig;
import org.alinous.net.mail.MailWrapper;
import org.alinous.script.functions.ArgumentDeclare;
import org.alinous.script.functions.system.AbstractSystemFunction;
import org.alinous.script.runtime.IPathElement;
import org.alinous.script.runtime.IScriptVariable;
import org.alinous.script.runtime.PathElementFactory;
import org.alinous.script.runtime.ScriptArray;
import org.alinous.script.runtime.ScriptDomVariable;
import org.alinous.script.runtime.VariableRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailSend
extends AbstractSystemFunction {
    public static String QUALIFIED_NAME = "MAIL.SEND";
    public static String MAIL_ARG = "arg0";

    public MailSend() {
        ArgumentDeclare arg = new ArgumentDeclare("$", MAIL_ARG);
        this.argmentsDeclare.addArgument(arg);
    }

    @Override
    public boolean execute(PostContext context, VariableRepository valRepo) throws ExecutionException {
        VariableRepository newValRepo = new VariableRepository();
        this.handleArguments(context, valRepo, newValRepo);
        IPathElement ipath = PathElementFactory.buildPathElement(MAIL_ARG);
        IScriptVariable val = newValRepo.getVariable(ipath, context);
        if (!(val instanceof ScriptDomVariable)) {
            throw new ExecutionException(QUALIFIED_NAME + "() argument is wrong.");
        }
        ScriptDomVariable mailObject = (ScriptDomVariable)val;
        AlinousCore core = context.getCore();
        AlinousMailConfig mailconfig = core.getConfig().getMailConfig();
        if (mailconfig == null) {
            throw new ExecutionException(QUALIFIED_NAME + "() configration about mail server at alinous-config.xml is wrong.");
        }
        MailWrapper mgr = new MailWrapper(mailconfig);
        Map<String, String> map = this.findField(mailObject, mgr);
        if (map.get("FROM") == null || map.get("SUBJECT") == null || map.get("BODY") == null) {
            throw new ExecutionException("FROM, SUBJECT or BODY is empty");
        }
        if (mailconfig.getPopMethod() != null && mailconfig.getPopUser() != null && mailconfig.getAuthPass() != null) {
            mgr.popcheck();
        }
        try {
            mgr.connect();
            mgr.sendMail(map.get("FROM"), map.get("SUBJECT"), map.get("BODY"));
        }
        catch (AlinousException e) {
            throw new ExecutionException(e, "Failed in sending mail");
        }
        finally {
            mgr.disconnect();
        }
        return true;
    }

    private Map<String, String> findField(ScriptDomVariable mailObject, MailWrapper mgr) {
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator<String> it = mailObject.getPropertiesIterator();
        while (it.hasNext()) {
            IScriptVariable val;
            String propName = it.next();
            if (propName.toUpperCase().equals("TO")) {
                this.addTo(mailObject.get(propName), mgr);
                continue;
            }
            if (propName.toUpperCase().equals("CC")) {
                this.addCC(mailObject.get(propName), mgr);
                continue;
            }
            if (propName.toUpperCase().equals("BCC")) {
                this.addBcc(mailObject.get(propName), mgr);
                continue;
            }
            if (propName.toUpperCase().equals("FROM")) {
                val = mailObject.get(propName);
                if (!(val instanceof ScriptDomVariable)) continue;
                map.put("FROM", ((ScriptDomVariable)val).getValue());
                continue;
            }
            if (propName.toUpperCase().equals("SUBJECT")) {
                val = mailObject.get(propName);
                if (!(val instanceof ScriptDomVariable)) continue;
                map.put("SUBJECT", ((ScriptDomVariable)val).getValue());
                continue;
            }
            if (!propName.toUpperCase().equals("BODY") || !((val = mailObject.get(propName)) instanceof ScriptDomVariable)) continue;
            map.put("BODY", ((ScriptDomVariable)val).getValue());
        }
        return map;
    }

    private void addBcc(IScriptVariable val, MailWrapper mgr) {
        if (val instanceof ScriptDomVariable) {
            String str = ((ScriptDomVariable)val).getValue();
            mgr.addBcc(str);
            return;
        }
        if (val instanceof ScriptArray) {
            ScriptArray array = (ScriptArray)val;
            Iterator<IScriptVariable> it = array.iterator();
            while (it.hasNext()) {
                String str;
                IScriptVariable v = it.next();
                if (!(v instanceof ScriptDomVariable) || (str = ((ScriptDomVariable)v).getValue()) == null) continue;
                mgr.addBcc(str);
            }
        }
    }

    private void addTo(IScriptVariable val, MailWrapper mgr) {
        if (val instanceof ScriptDomVariable) {
            String str = ((ScriptDomVariable)val).getValue();
            mgr.addTo(str);
            return;
        }
        if (val instanceof ScriptArray) {
            ScriptArray array = (ScriptArray)val;
            Iterator<IScriptVariable> it = array.iterator();
            while (it.hasNext()) {
                String str;
                IScriptVariable v = it.next();
                if (!(v instanceof ScriptDomVariable) || (str = ((ScriptDomVariable)v).getValue()) == null) continue;
                mgr.addTo(str);
            }
        }
    }

    private void addCC(IScriptVariable val, MailWrapper mgr) {
        if (val instanceof ScriptDomVariable) {
            String str = ((ScriptDomVariable)val).getValue();
            mgr.addCc(str);
            return;
        }
        if (val instanceof ScriptArray) {
            ScriptArray array = (ScriptArray)val;
            Iterator<IScriptVariable> it = array.iterator();
            while (it.hasNext()) {
                String str;
                IScriptVariable v = it.next();
                if (!(v instanceof ScriptDomVariable) || (str = ((ScriptDomVariable)v).getValue()) == null) continue;
                mgr.addCc(str);
            }
        }
    }

    @Override
    public String getName() {
        return QUALIFIED_NAME;
    }

    @Override
    public IScriptVariable getResult() {
        return null;
    }
}

