/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.script.runtime;

import org.alinous.exec.pages.PostContext;
import org.alinous.expections.ExecutionException;
import org.alinous.script.runtime.ArrayPathElement;
import org.alinous.script.runtime.IPathElement;
import org.alinous.script.runtime.IScriptVariable;
import org.alinous.script.runtime.ScriptArray;
import org.alinous.script.runtime.ScriptDomVariable;
import org.alinous.script.runtime.VariableRepository;

public class PathElement
implements IPathElement {
    private IPathElement child;
    private IPathElement parent;
    private String path;
    private boolean isArrayContainer;

    public PathElement(String path) {
        this.path = path;
    }

    public String getPathString(PostContext context, VariableRepository valRepo) throws ExecutionException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.path);
        if (this.child != null && this.child instanceof PathElement) {
            buffer.append(".");
            buffer.append(this.child.getPathString(context, valRepo));
        } else if (this.child != null && this.child instanceof ArrayPathElement) {
            buffer.append(this.child.getPathString(context, valRepo));
        }
        return buffer.toString();
    }

    public String getPath() {
        return this.path;
    }

    public IPathElement getChild() {
        return this.child;
    }

    public void setChild(IPathElement child) {
        this.child = child;
        if (child instanceof ArrayPathElement) {
            this.isArrayContainer = true;
        }
    }

    public IPathElement getParent() {
        return this.parent;
    }

    public void setParent(IPathElement parent) {
        this.parent = parent;
    }

    public IScriptVariable input(IScriptVariable container, PostContext context, VariableRepository valRepo) throws ExecutionException {
        if (container instanceof VariableRepository) {
            return this.inputIntoRepository((VariableRepository)container);
        }
        if (!(container instanceof ScriptDomVariable)) {
            throw new ExecutionException("Failed to input variable");
        }
        ScriptDomVariable domVariable = (ScriptDomVariable)container;
        IScriptVariable cur = domVariable.get(this.path);
        if (!(cur instanceof ScriptDomVariable) && !this.isArrayContainer) {
            cur = null;
        }
        if (!(cur instanceof ScriptArray) && this.isArrayContainer) {
            cur = null;
        }
        if (cur == null) {
            if (!this.isArrayContainer) {
                cur = new ScriptDomVariable(this.path);
            } else if (this.isArrayContainer) {
                cur = new ScriptArray(this.path);
            }
            domVariable.put(cur);
        }
        return cur;
    }

    private IScriptVariable inputIntoRepository(VariableRepository container) {
        IScriptVariable cur = container.getValue(this.path);
        if (!(cur instanceof ScriptDomVariable) && !this.isArrayContainer) {
            cur = null;
        }
        if (!(cur instanceof ScriptArray) && this.isArrayContainer) {
            cur = null;
        }
        if (cur == null) {
            if (!this.isArrayContainer) {
                cur = new ScriptDomVariable(this.path);
            } else if (this.isArrayContainer) {
                cur = new ScriptArray(this.path);
            }
            container.putValue(cur);
        }
        return cur;
    }

    public boolean isLeaf() {
        return this.child == null;
    }

    public int getType() {
        return 1;
    }

    public IPathElement getLast() {
        IPathElement cur = this;
        while (cur.getChild() != null) {
            cur = cur.getChild();
        }
        return cur;
    }

    public IPathElement removeLast() {
        IPathElement copy = this.deepCopy();
        IPathElement last = copy.getLast();
        IPathElement cur = copy;
        while (cur.getChild() != last) {
            if (cur.getChild() == null) {
                return null;
            }
            cur = cur.getChild();
        }
        cur.setChild(null);
        return copy;
    }

    protected IPathElement deepCopy() {
        PathElement retElement = new PathElement(this.path);
        IPathElement curSrc = this;
        IPathElement curDst = retElement;
        while (curSrc.getChild() != null) {
            curSrc = curSrc.getChild();
            IPathElement newElement = null;
            try {
                newElement = (IPathElement)curSrc.clone();
                newElement.setParent(curDst);
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
            curDst.setChild(newElement);
            curDst = newElement;
        }
        return retElement;
    }

    public Object clone() throws CloneNotSupportedException {
        PathElement newElement = new PathElement(this.path);
        newElement.isArrayContainer = this.isArrayContainer;
        return newElement;
    }

    public boolean isArrayContainer() {
        return this.isArrayContainer;
    }

    public void setArrayContainer(boolean isArrayContainer) {
        this.isArrayContainer = isArrayContainer;
    }
}

