/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.script.runtime;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.alinous.AlinousCore;
import org.alinous.debug.StepInCandidates;
import org.alinous.exec.pages.PostContext;
import org.alinous.expections.ExecutionException;
import org.alinous.script.IScriptSentence;
import org.alinous.script.runtime.ArrayPathElement;
import org.alinous.script.runtime.IPathElement;
import org.alinous.script.runtime.IScriptVariable;
import org.alinous.script.runtime.JDomScriptObjectFactory;
import org.alinous.script.runtime.PathElement;
import org.alinous.script.runtime.ScriptDomVariable;
import org.alinous.script.runtime.VariableRepository;
import org.jdom.Content;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptArray
implements IScriptVariable,
Cloneable {
    public static final String TAG_ARRAY = "ARRAY";
    public static final String ATTR_NAME = "name";
    private String name;
    private List<IScriptVariable> variables = new CopyOnWriteArrayList<IScriptVariable>();
    private IScriptVariable parent;
    private int parentArrayIndex;

    public ScriptArray() {
        this.parentArrayIndex = -1;
    }

    public ScriptArray(String name) {
        this.name = name;
        this.parentArrayIndex = -1;
    }

    @Override
    public String getType() {
        return TAG_ARRAY;
    }

    public void add(IScriptVariable variable) {
        variable.setParent(this);
        variable.setParentArrayIndex(this.variables.size());
        if (AlinousCore.debug) {
            variable.setName("[" + this.variables.size() + "]");
        }
        this.variables.add(variable);
    }

    public void putAt(IScriptVariable variable, int index) {
        int defSize = this.variables.size();
        if (defSize - 1 < index) {
            int appendNum = index - this.variables.size();
            for (int i = 0; i < appendNum + 1; ++i) {
                ScriptDomVariable v = new ScriptDomVariable("");
                v.setParent(this);
                v.setParentArrayIndex(i + defSize);
                v.setName("[" + i + "]");
                this.variables.add(v);
            }
        }
        variable.setParent(this);
        variable.setParentArrayIndex(index);
        this.variables.set(index, variable);
        if (AlinousCore.debug) {
            variable.setName("[" + index + "]");
        }
    }

    public Iterator<IScriptVariable> iterator() {
        return this.variables.iterator();
    }

    public int getSize() {
        return this.variables.size();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void exportIntoJDomElement(Element parent) {
        Element arrayElement = new Element(TAG_ARRAY);
        arrayElement.setAttribute(ATTR_NAME, this.name);
        for (IScriptVariable val : this.variables) {
            val.exportIntoJDomElement(arrayElement);
        }
        parent.addContent((Content)arrayElement);
    }

    @Override
    public void importFromJDomElement(Element arrayElement) {
        this.name = arrayElement.getAttributeValue(ATTR_NAME);
        List list = arrayElement.getChildren();
        for (Element element : list) {
            IScriptVariable val = JDomScriptObjectFactory.createScriptVariable(element);
            val.importFromJDomElement(element);
            val.setParent(this);
            this.variables.add(val);
        }
    }

    @Override
    public IScriptVariable get(String name) {
        Iterator<IScriptVariable> it = this.iterator();
        while (it.hasNext()) {
            IScriptVariable val = it.next();
            if (!val.getName().equals(name)) continue;
            return val;
        }
        return null;
    }

    public IScriptVariable get(int i) {
        if (i > this.variables.size() - 1) {
            return null;
        }
        return this.variables.get(i);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ScriptArray ar = new ScriptArray(this.name);
        for (IScriptVariable val : this.variables) {
            ar.add((IScriptVariable)val.clone());
        }
        return ar;
    }

    @Override
    public IScriptVariable getParent() {
        return this.parent;
    }

    @Override
    public void setParent(IScriptVariable parent) {
        this.parent = parent;
    }

    @Override
    public int getParentArrayIndex() {
        return this.parentArrayIndex;
    }

    @Override
    public void setParentArrayIndex(int parentArrayIndex) {
        this.parentArrayIndex = parentArrayIndex;
    }

    @Override
    public IPathElement getPath() {
        IPathElement thisPath = null;
        thisPath = this.parentArrayIndex < 0 ? new PathElement(this.name) : new ArrayPathElement(this.parentArrayIndex);
        IPathElement path = this.parent.getPath();
        if (path == null) {
            return thisPath;
        }
        this.getLeaf(path).setChild(thisPath);
        return path;
    }

    private IPathElement getLeaf(IPathElement first) {
        IPathElement ret = first;
        while (!ret.isLeaf()) {
            ret = ret.getChild();
        }
        return ret;
    }

    @Override
    public void canStepInStatements(StepInCandidates candidates) {
    }

    @Override
    public IScriptVariable executeStatement(PostContext context, VariableRepository valRepo) throws ExecutionException {
        return null;
    }

    @Override
    public void setCallerSentence(IScriptSentence callerSentence) {
    }
}

