/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.script.runtime;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.alinous.debug.StepInCandidates;
import org.alinous.exec.pages.PostContext;
import org.alinous.expections.ExecutionException;
import org.alinous.script.IScriptSentence;
import org.alinous.script.runtime.ArrayPathElement;
import org.alinous.script.runtime.IPathElement;
import org.alinous.script.runtime.IScriptVariable;
import org.alinous.script.runtime.JDomScriptObjectFactory;
import org.alinous.script.runtime.PathElement;
import org.alinous.script.runtime.ScriptVariable;
import org.alinous.script.runtime.VariableRepository;
import org.jdom.Content;
import org.jdom.Element;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptDomVariable
extends ScriptVariable
implements Cloneable {
    public static final String TAG_VARIABLE = "VARIABLE";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_VALUE = "value";
    public static final String ATTR_TYPE = "valuetype";
    private HashMap<String, IScriptVariable> map = new HashMap();
    private IScriptVariable parent;
    private int parentArrayIndex;

    public ScriptDomVariable(String name) {
        this.name = name;
        this.parentArrayIndex = -1;
        this.valueType = "STRING";
    }

    @Override
    public IScriptVariable get(String key) {
        return this.map.get(key);
    }

    public void put(IScriptVariable value) {
        value.setParent(this);
        value.setParentArrayIndex(-1);
        this.map.put(value.getName(), value);
    }

    public Iterator<String> getPropertiesIterator() {
        return this.map.keySet().iterator();
    }

    public int getNumProperties() {
        return this.map.size();
    }

    @Override
    public String getType() {
        return "HASH";
    }

    @Override
    public void exportIntoJDomElement(Element parent) {
        Element variableElement = new Element(TAG_VARIABLE);
        variableElement.setAttribute(ATTR_NAME, this.name);
        variableElement.setAttribute(ATTR_TYPE, this.valueType);
        if (this.value != null) {
            String encVal = new BASE64Encoder().encode(this.value.getBytes());
            variableElement.setText(encVal);
        }
        for (String prop : this.map.keySet()) {
            IScriptVariable val = this.map.get(prop);
            val.exportIntoJDomElement(variableElement);
        }
        parent.addContent((Content)variableElement);
    }

    @Override
    public void importFromJDomElement(Element variableElement) {
        this.name = variableElement.getAttributeValue(ATTR_NAME);
        this.valueType = variableElement.getAttributeValue(ATTR_TYPE);
        String encString = variableElement.getText();
        if (encString != null) {
            BASE64Decoder decorder = new BASE64Decoder();
            try {
                this.value = new String(decorder.decodeBuffer(encString));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        List list = variableElement.getChildren();
        for (Element element : list) {
            IScriptVariable val = JDomScriptObjectFactory.createScriptVariable(element);
            val.importFromJDomElement(element);
            this.map.put(val.getName(), val);
            val.setParent(this);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ScriptDomVariable dom = new ScriptDomVariable(this.name);
        dom.value = this.value;
        dom.valueType = this.valueType;
        for (String key : this.map.keySet()) {
            IScriptVariable innerVariable = this.map.get(key);
            IScriptVariable clonedVal = (IScriptVariable)innerVariable.clone();
            dom.map.put(key, clonedVal);
            clonedVal.setParent(dom);
        }
        return dom;
    }

    @Override
    public IScriptVariable getParent() {
        return this.parent;
    }

    @Override
    public void setParent(IScriptVariable parent) {
        this.parent = parent;
    }

    @Override
    public int getParentArrayIndex() {
        return this.parentArrayIndex;
    }

    @Override
    public void setParentArrayIndex(int parentArrayIndex) {
        this.parentArrayIndex = parentArrayIndex;
    }

    @Override
    public IPathElement getPath() {
        IPathElement thisPath = null;
        thisPath = this.parentArrayIndex < 0 ? new PathElement(this.name) : new ArrayPathElement(this.parentArrayIndex);
        IPathElement path = this.parent.getPath();
        if (path == null) {
            return thisPath;
        }
        this.getLeaf(path).setChild(thisPath);
        return path;
    }

    public void releaseProperty(String prop) {
        this.map.remove(prop);
    }

    private IPathElement getLeaf(IPathElement first) {
        IPathElement ret = first;
        while (!ret.isLeaf()) {
            ret = ret.getChild();
        }
        return ret;
    }

    @Override
    public void canStepInStatements(StepInCandidates candidates) {
    }

    @Override
    public IScriptVariable executeStatement(PostContext context, VariableRepository valRepo) throws ExecutionException {
        return null;
    }

    @Override
    public void setCallerSentence(IScriptSentence callerSentence) {
    }
}

