/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.script.sql.condition;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.alinous.expections.ExecutionException;
import org.alinous.script.runtime.VariableRepository;
import org.alinous.script.sql.adjustopt.AdjustSet;
import org.alinous.script.sql.adjustopt.AdjustWhere;
import org.alinous.script.sql.condition.ISQLContainerExpression;
import org.alinous.script.sql.condition.ISQLExpression;

public class AndExpression
implements ISQLContainerExpression {
    private List<ISQLExpression> expressions = new CopyOnWriteArrayList<ISQLExpression>();

    public void addExpressions(ISQLExpression expressions) {
        this.expressions.add(expressions);
    }

    public void acceptVariables(VariableRepository providor, AdjustWhere adjustWhere, AdjustSet adjustSet) {
        for (ISQLExpression exp : this.expressions) {
            exp.acceptVariables(providor, adjustWhere, adjustSet);
        }
    }

    public String extract() throws ExecutionException {
        StringBuffer buffer = new StringBuffer();
        String AND = " AND ";
        boolean first = true;
        for (ISQLExpression exp : this.expressions) {
            if (!exp.isReady()) continue;
            if (first) {
                first = false;
            } else {
                buffer.append(AND);
            }
            buffer.append(exp.extract());
        }
        return buffer.toString();
    }

    public boolean isReady() throws ExecutionException {
        for (ISQLExpression exp : this.expressions) {
            if (!exp.isReady()) continue;
            return true;
        }
        return false;
    }
}

