/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.script.sql.other;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.alinous.expections.ExecutionException;
import org.alinous.script.runtime.VariableRepository;
import org.alinous.script.sql.ISQLScriptObject;
import org.alinous.script.sql.adjustopt.AdjustSet;
import org.alinous.script.sql.adjustopt.AdjustWhere;
import org.alinous.script.sql.other.SelectColumnElement;
import org.alinous.script.sql.statement.ColumnIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnList
implements ISQLScriptObject {
    private List<SelectColumnElement> columnList = new CopyOnWriteArrayList<SelectColumnElement>();

    public void addColumns(SelectColumnElement col) {
        this.columnList.add(col);
    }

    public void addColumns(ColumnIdentifier col) {
        SelectColumnElement selCol = new SelectColumnElement();
        selCol.setColumnName(col);
        this.columnList.add(selCol);
    }

    public void addColumns(ColumnIdentifier col, String order) {
        SelectColumnElement selCol = new SelectColumnElement();
        selCol.setColumnName(col);
        selCol.setOrder(order);
        this.columnList.add(selCol);
    }

    @Override
    public void acceptVariables(VariableRepository providor, AdjustWhere adjustWhere, AdjustSet adjustSet) {
        for (SelectColumnElement colid : this.columnList) {
            colid.acceptVariables(providor, adjustWhere, adjustSet);
        }
    }

    @Override
    public boolean isReady() throws ExecutionException {
        return this.columnList.size() > 0;
    }

    @Override
    public String extract() throws ExecutionException {
        StringBuffer buffer = new StringBuffer();
        boolean first = true;
        for (SelectColumnElement colId : this.columnList) {
            if (first) {
                first = false;
            } else {
                buffer.append(", ");
            }
            buffer.append(colId.extract());
        }
        return buffer.toString();
    }

    public int size() {
        return this.size();
    }

    public Iterator<SelectColumnElement> iterator() {
        return this.columnList.iterator();
    }
}

