/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.script.sql.statement;

import org.alinous.AlinousUtils;
import org.alinous.expections.ExecutionException;
import org.alinous.script.runtime.IPathElement;
import org.alinous.script.runtime.IScriptVariable;
import org.alinous.script.runtime.ScriptArray;
import org.alinous.script.runtime.ScriptDomVariable;
import org.alinous.script.runtime.VariableRepository;
import org.alinous.script.sql.adjustopt.AdjustSet;
import org.alinous.script.sql.adjustopt.AdjustWhere;
import org.alinous.script.sql.statement.ISQLStatement;

public class SQLVariable
implements ISQLStatement {
    private String prefix;
    private IPathElement pathElement;
    private VariableRepository valueProvidor;

    public IPathElement getPathElement() {
        return this.pathElement;
    }

    public void setPathElement(IPathElement pathElement) {
        this.pathElement = pathElement;
    }

    public void acceptVariables(VariableRepository providor, AdjustWhere adjustWhere, AdjustSet adjustSet) {
        this.valueProvidor = providor;
    }

    public String extract() throws ExecutionException {
        IScriptVariable value = this.valueProvidor.getVariable(this.pathElement, null);
        if (value == null) {
            return "null";
        }
        if (value instanceof ScriptDomVariable) {
            return this.extractScriptDom((ScriptDomVariable)value);
        }
        if (value instanceof ScriptArray) {
            return this.extractScriptArray((ScriptArray)value);
        }
        return value.toString();
    }

    private String extractScriptArray(ScriptArray array) throws ExecutionException {
        StringBuffer buff = new StringBuffer();
        int max = array.getSize();
        boolean first = true;
        for (int i = 0; i < max; ++i) {
            if (first) {
                first = false;
            } else {
                buff.append(", ");
            }
            IScriptVariable val = array.get(i);
            if (!(val instanceof ScriptDomVariable)) {
                buff.append("null");
                continue;
            }
            ScriptDomVariable domVal = (ScriptDomVariable)val;
            buff.append("'");
            buff.append(domVal.getValue());
            buff.append("'");
        }
        return buff.toString();
    }

    private String extractScriptDom(ScriptDomVariable value) {
        if (value.getValueType().equals("STRING")) {
            return "'" + AlinousUtils.sqlEscape(value.getValue()) + "'";
        }
        return value.getValue();
    }

    public boolean isReady() throws ExecutionException {
        ScriptDomVariable domVal;
        IScriptVariable value = this.valueProvidor.getVariable(this.pathElement, null);
        if (value == null) {
            return false;
        }
        return !(value instanceof ScriptDomVariable) || (domVal = (ScriptDomVariable)value).getValue() != null;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }
}

