/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.script.statement;

import org.alinous.debug.StepInCandidates;
import org.alinous.exec.pages.PostContext;
import org.alinous.expections.AlinousException;
import org.alinous.expections.ExecutionException;
import org.alinous.script.IScriptSentence;
import org.alinous.script.basic.condition.IScriptCondition;
import org.alinous.script.basic.condition.JDomConditionFactory;
import org.alinous.script.basic.type.IStatement;
import org.alinous.script.runtime.IScriptVariable;
import org.alinous.script.runtime.ScriptDomVariable;
import org.alinous.script.runtime.VariableRepository;
import org.jdom.Content;
import org.jdom.Element;

public class BooleanStatement
implements IStatement {
    private IScriptCondition condition;
    private IScriptSentence callerSentence;

    public void canStepInStatements(StepInCandidates candidates) {
        this.condition.canStepInStatements(candidates);
    }

    public IScriptVariable executeStatement(PostContext context, VariableRepository valRepo) throws ExecutionException {
        boolean bl = this.condition.evaluate(context, valRepo);
        ScriptDomVariable domVal = new ScriptDomVariable("");
        domVal.setValue(Boolean.toString(bl));
        domVal.setValueType("BOOLEAN");
        return domVal;
    }

    public void exportIntoJDomElement(Element parent) throws AlinousException {
        Element element = new Element("STATEMENT");
        element.setAttribute("className", this.getClass().getName());
        parent.addContent((Content)element);
        this.condition.exportIntoJDomElement(element);
    }

    public void importFromJDomElement(Element element) throws AlinousException {
        Element cond = element.getChild("CONDITION");
        this.condition = JDomConditionFactory.createConditionFromJDomElement(cond);
        this.condition.importFromJDomElement(cond);
    }

    public void setCallerSentence(IScriptSentence callerSentence) {
        this.callerSentence = callerSentence;
        this.condition.setCallerSentence(callerSentence);
    }

    public IScriptCondition getCondition() {
        return this.condition;
    }

    public void setCondition(IScriptCondition condition) {
        this.condition = condition;
        this.condition.setCallerSentence(this.callerSentence);
    }
}

