/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.script.statement;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.alinous.debug.StepInCandidates;
import org.alinous.exec.pages.PostContext;
import org.alinous.expections.AlinousException;
import org.alinous.expections.AlinousNullPointerException;
import org.alinous.expections.ExecutionException;
import org.alinous.script.IScriptSentence;
import org.alinous.script.basic.type.IStatement;
import org.alinous.script.basic.type.StatementJDomFactory;
import org.alinous.script.runtime.IScriptVariable;
import org.alinous.script.runtime.ScriptDomVariable;
import org.alinous.script.runtime.VariableRepository;
import org.jdom.Content;
import org.jdom.Element;

public class ModuloStatement
implements IStatement {
    private IStatement first;
    private List<IStatement> opeStatements = new LinkedList<IStatement>();
    private IScriptSentence callerSentence;

    public IStatement getFirst() {
        return this.first;
    }

    public void setFirst(IStatement first) {
        this.first = first;
    }

    public void addOperation(IStatement ope) {
        ope.setCallerSentence(this.callerSentence);
        this.opeStatements.add(ope);
    }

    public void canStepInStatements(StepInCandidates candidates) {
        this.first.canStepInStatements(candidates);
        for (IStatement stmt : this.opeStatements) {
            stmt.canStepInStatements(candidates);
        }
    }

    public IScriptVariable executeStatement(PostContext context, VariableRepository valRepo) throws ExecutionException {
        int intValue = 0;
        IScriptVariable val = this.first.executeStatement(context, valRepo);
        this.checkValue(val);
        intValue = Integer.parseInt(((ScriptDomVariable)val).getValue());
        if (this.opeStatements.size() != 1) {
            throw new ExecutionException("Cannot modulo.");
        }
        IStatement subStmt = this.opeStatements.get(0);
        val = subStmt.executeStatement(context, valRepo);
        int modVal = Integer.parseInt(((ScriptDomVariable)val).getValue());
        ScriptDomVariable retValue = new ScriptDomVariable("");
        retValue.setValue(Integer.toString(intValue %= modVal));
        return retValue;
    }

    private void checkValue(IScriptVariable val) throws ExecutionException {
        if (!(val instanceof ScriptDomVariable)) {
            throw new ExecutionException("Cannot execute modulo operation to array.");
        }
        if (((ScriptDomVariable)val).getValueType().equals("NULL")) {
            throw new AlinousNullPointerException("Null Pointer Exception");
        }
        String type = ((ScriptDomVariable)val).getValueType();
        if (!type.equals("NUMBER") && !type.equals("DOUBLE")) {
            throw new ExecutionException("Cannot modulo String nor boolean.");
        }
    }

    public void exportIntoJDomElement(Element parent) throws AlinousException {
        Element element = new Element("STATEMENT");
        element.setAttribute("className", this.getClass().getName());
        parent.addContent((Content)element);
        this.first.exportIntoJDomElement(element);
        for (IStatement stmt : this.opeStatements) {
            stmt.exportIntoJDomElement(element);
        }
    }

    public void importFromJDomElement(Element element) throws AlinousException {
        boolean first = true;
        for (Element el : element.getChildren("STATEMENT")) {
            IStatement stmt = StatementJDomFactory.createStatementFromDom(el);
            stmt.importFromJDomElement(el);
            if (first) {
                first = false;
                this.first = stmt;
                continue;
            }
            this.opeStatements.add(stmt);
        }
    }

    public void setCallerSentence(IScriptSentence callerSentence) {
        this.callerSentence = callerSentence;
        this.first.setCallerSentence(callerSentence);
        Iterator<IStatement> it = this.opeStatements.iterator();
        while (it.hasNext()) {
            it.next().setCallerSentence(callerSentence);
        }
    }
}

