/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.script.statement;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.alinous.debug.StepInCandidates;
import org.alinous.exec.pages.PostContext;
import org.alinous.expections.AlinousException;
import org.alinous.expections.AlinousNullPointerException;
import org.alinous.expections.ExecutionException;
import org.alinous.script.IScriptSentence;
import org.alinous.script.basic.type.IStatement;
import org.alinous.script.basic.type.StatementJDomFactory;
import org.alinous.script.runtime.IScriptVariable;
import org.alinous.script.runtime.ScriptDomVariable;
import org.alinous.script.runtime.VariableRepository;
import org.alinous.script.statement.SubStatement;
import org.jdom.Content;
import org.jdom.Element;

public class MultipleStatement
implements IStatement {
    private IStatement first;
    private List<IStatement> opeStatements = new LinkedList<IStatement>();
    private IScriptSentence callerSentence;

    public void addOperation(IStatement ope) {
        ope.setCallerSentence(this.callerSentence);
        this.opeStatements.add(ope);
    }

    public IStatement getFirst() {
        return this.first;
    }

    public void setFirst(IStatement first) {
        first.setCallerSentence(this.callerSentence);
        this.first = first;
    }

    public IScriptVariable executeStatement(PostContext context, VariableRepository valRepo) throws ExecutionException {
        if (this.isDouble(context, valRepo)) {
            return this.executeDouble(context, valRepo);
        }
        int intValue = 0;
        IScriptVariable val = this.first.executeStatement(context, valRepo);
        this.checkValue(val);
        intValue = Integer.parseInt(((ScriptDomVariable)val).getValue());
        for (SubStatement subStatement : this.opeStatements) {
            val = subStatement.getTarget().executeStatement(context, valRepo);
            this.checkValue(val);
            int tmpVal = Integer.parseInt(((ScriptDomVariable)val).getValue());
            if (subStatement.getOpe().equals("*")) {
                intValue *= tmpVal;
                continue;
            }
            intValue /= tmpVal;
        }
        ScriptDomVariable scriptDomVariable = new ScriptDomVariable("");
        scriptDomVariable.setValue(Integer.toString(intValue));
        scriptDomVariable.setValueType("NUMBER");
        return scriptDomVariable;
    }

    private IScriptVariable executeDouble(PostContext context, VariableRepository valRepo) throws ExecutionException {
        double dblValue = 0.0;
        IScriptVariable val = this.first.executeStatement(context, valRepo);
        dblValue = Double.parseDouble(((ScriptDomVariable)val).getValue());
        for (SubStatement subStatement : this.opeStatements) {
            val = subStatement.getTarget().executeStatement(context, valRepo);
            double tmpVal = Double.parseDouble(((ScriptDomVariable)val).getValue());
            if (subStatement.getOpe().equals("*")) {
                dblValue *= tmpVal;
                continue;
            }
            dblValue /= tmpVal;
        }
        ScriptDomVariable scriptDomVariable = new ScriptDomVariable("");
        scriptDomVariable.setValue(Double.toString(dblValue));
        scriptDomVariable.setValueType("DOUBLE");
        return scriptDomVariable;
    }

    private boolean isDouble(PostContext context, VariableRepository valRepo) throws ExecutionException {
        IScriptVariable val = this.first.executeStatement(context, valRepo);
        this.checkValue(val);
        String type = ((ScriptDomVariable)val).getValueType();
        if (type.equals("DOUBLE")) {
            return true;
        }
        for (SubStatement subStatement : this.opeStatements) {
            val = subStatement.getTarget().executeStatement(context, valRepo);
            this.checkValue(val);
            type = ((ScriptDomVariable)val).getValueType();
            if (!type.equals("DOUBLE")) continue;
            return true;
        }
        return false;
    }

    private void checkValue(IScriptVariable val) throws ExecutionException {
        if (!(val instanceof ScriptDomVariable)) {
            throw new ExecutionException("Cannot multiple/divide array.");
        }
        if (((ScriptDomVariable)val).getValueType().equals("NULL")) {
            throw new AlinousNullPointerException("Null Pointer Exception");
        }
        String type = ((ScriptDomVariable)val).getValueType();
        if (!type.equals("NUMBER") && !type.equals("DOUBLE")) {
            throw new ExecutionException("Cannot multiple/divide String nor boolean.");
        }
    }

    public void exportIntoJDomElement(Element parent) throws AlinousException {
        Element element = new Element("STATEMENT");
        element.setAttribute("className", this.getClass().getName());
        parent.addContent((Content)element);
        this.first.exportIntoJDomElement(element);
        for (IStatement stmt : this.opeStatements) {
            stmt.exportIntoJDomElement(element);
        }
    }

    public void importFromJDomElement(Element element) throws AlinousException {
        boolean first = true;
        for (Element el : element.getChildren("STATEMENT")) {
            IStatement stmt = StatementJDomFactory.createStatementFromDom(el);
            stmt.importFromJDomElement(el);
            if (first) {
                first = false;
                this.first = stmt;
                continue;
            }
            this.opeStatements.add(stmt);
        }
    }

    public void canStepInStatements(StepInCandidates candidates) {
        this.first.canStepInStatements(candidates);
        for (IStatement stmt : this.opeStatements) {
            stmt.canStepInStatements(candidates);
        }
    }

    public void setCallerSentence(IScriptSentence callerSentence) {
        this.callerSentence = callerSentence;
        this.first.setCallerSentence(callerSentence);
        Iterator<IStatement> it = this.opeStatements.iterator();
        while (it.hasNext()) {
            it.next().setCallerSentence(callerSentence);
        }
    }
}

