/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.security;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.alinous.AlinousConfig;
import org.alinous.AlinousCore;
import org.alinous.AlinousUtils;
import org.alinous.datasrc.AlinousDataSourceManager;
import org.alinous.datasrc.exception.DataSourceException;
import org.alinous.datasrc.types.Record;
import org.alinous.exec.SessionController;
import org.alinous.exec.pages.PostContext;
import org.alinous.expections.AlinousException;
import org.alinous.expections.AlinousSecurityException;
import org.alinous.repository.AlinousSystemRepository;
import org.alinous.script.runtime.IPathElement;
import org.alinous.script.runtime.IScriptVariable;
import org.alinous.script.runtime.PathElementFactory;
import org.alinous.script.runtime.ScriptArray;
import org.alinous.script.runtime.ScriptDomVariable;
import org.alinous.script.runtime.VariableRepository;
import org.alinous.security.SecurityConfig;
import org.alinous.security.SecurityRelmManager;
import org.alinous.security.Zone;
import org.alinous.security.ZoneMatchContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlinousSecurityManager {
    static final String USER_NAME_PATH = "SESSION.AUTH.USER";
    static final String USER_ROLE_PATH = "SESSION.AUTH.ROLES";
    static final String BASIC_USER_ROLE_PATH = "SESSION.BASIC.AUTH.USER";
    static final String BASIC_ROLES_ROLE_PATH = "SESSION.BASIC.AUTH.ROLES";
    private AlinousCore alinousCore;
    private SecurityRelmManager relm;
    private AlinousSystemRepository sysRepo;
    private AlinousConfig config;
    private String name;
    private String nameBasic;
    private List<String> roles = new ArrayList<String>();
    private List<String> basicRoles = new ArrayList<String>();

    public AlinousSecurityManager(AlinousCore alinousCore, AlinousDataSourceManager dataSourceManager, AlinousSystemRepository sysRepo, AlinousConfig config) {
        this.relm = new SecurityRelmManager(dataSourceManager, config);
        this.config = config;
        this.sysRepo = sysRepo;
    }

    public void init() throws AlinousException {
        SecurityConfig secConfig = this.config.getSecurityConfig();
        if (secConfig == null) {
            return;
        }
        this.relm.initRelmTable();
    }

    public void checkSecurity(String path, AlinousConfig config, PostContext context) throws AlinousException {
        SecurityConfig securityConfig = config.getSecurityConfig();
        path = path.replaceAll("\\\\", "/");
        if (securityConfig == null) {
            return;
        }
        String innerPath = null;
        if (context != null) {
            innerPath = context.getNextAction();
        }
        Zone zone = this.findLongestMatch(path, securityConfig, false);
        Zone zoneBasic = this.findLongestMatch(path, securityConfig, true);
        Zone innserZone = null;
        Zone innserZoneBasic = null;
        if (innerPath != null) {
            String innerModuleName = AlinousUtils.getModuleName(innerPath);
            innserZone = this.findLongestMatch(innerModuleName, securityConfig, false);
            innserZoneBasic = this.findLongestMatch(innerModuleName, securityConfig, true);
        }
        if (zone == null && innserZone == null && zoneBasic == null && innserZoneBasic == null) {
            return;
        }
        this.initAuthenticatedInfo(context);
        if (this.nameBasic == null && (zoneBasic != null || innserZoneBasic != null)) {
            int reason = 0;
            Zone reasonZone = null;
            if (zoneBasic != null) {
                reason = 1;
                reasonZone = zoneBasic;
            } else if (innserZoneBasic != null) {
                reason = 2;
                reasonZone = innserZoneBasic;
            }
            throw new AlinousSecurityException(reason, reasonZone);
        }
        if (innserZoneBasic != null && !innserZoneBasic.checkRole(this.basicRoles)) {
            throw new AlinousSecurityException(2, innserZoneBasic);
        }
        if (zoneBasic != null && !zoneBasic.checkRole(this.basicRoles)) {
            throw new AlinousSecurityException(1, zoneBasic);
        }
        if (this.name == null && (zone != null || innserZone != null)) {
            int reason = 0;
            Zone reasonZone = null;
            if (zone != null) {
                reason = 1;
                reasonZone = zone;
            } else if (innserZone != null) {
                reason = 2;
                reasonZone = innserZone;
            }
            throw new AlinousSecurityException(reason, reasonZone);
        }
        if (zone != null && !zone.checkRole(this.roles)) {
            throw new AlinousSecurityException(1, zone);
        }
        if (innserZone != null && !innserZone.checkRole(this.roles)) {
            throw new AlinousSecurityException(2, innserZone);
        }
    }

    private VariableRepository initAuthenticatedInfo(PostContext context) throws AlinousException {
        IScriptVariable roleVal;
        int i;
        int size;
        ScriptArray ar;
        this.name = null;
        this.roles.clear();
        this.basicRoles.clear();
        AlinousCore core = context.getCore();
        SessionController sessionControleler = new SessionController(core.getSystemRepository(), context.getSessionId());
        VariableRepository valRepo = new VariableRepository();
        sessionControleler.updateSession(valRepo, context);
        IPathElement path = PathElementFactory.buildPathElement(USER_NAME_PATH);
        IScriptVariable val = valRepo.getVariable(path, context);
        if (val instanceof ScriptDomVariable) {
            this.name = ((ScriptDomVariable)val).getValue();
        }
        if ((val = valRepo.getVariable(path = PathElementFactory.buildPathElement(USER_ROLE_PATH), context)) instanceof ScriptDomVariable) {
            this.roles.add(((ScriptDomVariable)val).getValue());
        } else if (val instanceof ScriptArray) {
            ar = (ScriptArray)val;
            size = ar.getSize();
            for (i = 0; i < size; ++i) {
                roleVal = ar.get(i);
                if (!(roleVal instanceof ScriptDomVariable)) continue;
                this.roles.add(((ScriptDomVariable)roleVal).getValue());
            }
        }
        path = PathElementFactory.buildPathElement(BASIC_USER_ROLE_PATH);
        val = valRepo.getVariable(path, context);
        if (val instanceof ScriptDomVariable) {
            this.nameBasic = ((ScriptDomVariable)val).getValue();
        }
        if ((val = valRepo.getVariable(path = PathElementFactory.buildPathElement(BASIC_ROLES_ROLE_PATH), context)) instanceof ScriptDomVariable) {
            this.basicRoles.add(((ScriptDomVariable)val).getValue());
        } else if (val instanceof ScriptArray) {
            ar = (ScriptArray)val;
            size = ar.getSize();
            for (i = 0; i < size; ++i) {
                roleVal = ar.get(i);
                if (!(roleVal instanceof ScriptDomVariable)) continue;
                this.basicRoles.add(((ScriptDomVariable)roleVal).getValue());
            }
        }
        return valRepo;
    }

    private boolean isExceptionalPage(String path, SecurityConfig securityConfig) {
        return securityConfig.isExceptionalPage(path + ".html");
    }

    public Zone findLongestMatch(String path, SecurityConfig securityConfig, boolean isBasic) {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (path.endsWith("/")) {
            path = path + "index";
        }
        if (this.isExceptionalPage(path, securityConfig)) {
            return null;
        }
        ZoneMatchContext currentContext = null;
        for (Zone zone : securityConfig.getZones()) {
            ZoneMatchContext context = zone.getContext();
            if (!context.match(path) || isBasic && context.getZone().isUseForm() || !isBasic && !context.getZone().isUseForm()) continue;
            if (currentContext == null) {
                currentContext = context;
                continue;
            }
            if (currentContext.getNumSegments() >= context.getNumSegments()) continue;
            currentContext = context;
        }
        if (currentContext == null) {
            return null;
        }
        return currentContext.getZone();
    }

    public void authenticate(String user, String password, String sessionId) throws AlinousException {
        if (user == null || password == null) {
            return;
        }
        SecurityConfig secConfig = this.config.getSecurityConfig();
        if (secConfig == null) {
            return;
        }
        String roleColumn = secConfig.getRelmRoles();
        if (roleColumn == null) {
            return;
        }
        List<Record> recList = null;
        try {
            recList = this.relm.findRecords(user, password);
        }
        catch (DataSourceException e) {
            throw new AlinousException(e, "");
        }
        LinkedList<String> roles = new LinkedList<String>();
        for (Record rec : recList) {
            String role = rec.getFieldValue(roleColumn);
            if (role == null || role.equals("")) continue;
            roles.add(role);
        }
        this.updateSession(user, password, roles, sessionId);
    }

    private synchronized void updateSession(String user, String password, LinkedList<String> roles, String sessionId) throws AlinousException {
        if (roles.size() <= 0) {
            return;
        }
        if (sessionId == null) {
            return;
        }
        SessionController sessionController = new SessionController(this.sysRepo, sessionId);
        VariableRepository valRepo = new VariableRepository();
        PostContext context = new PostContext(this.alinousCore, null);
        sessionController.updateSession(valRepo, context);
        valRepo.putValue(BASIC_USER_ROLE_PATH, user, "STRING", null);
        int index = 0;
        for (String role : roles) {
            String pathStr = "SESSION.BASIC.AUTH.ROLES[" + index + "]";
            valRepo.putValue(pathStr, role, "STRING", null);
            ++index;
        }
        sessionController.storeSession(context, valRepo);
    }

    public static void writeErrorPage(Writer writer) throws IOException {
        writer.append("<html>");
        writer.append("<head>");
        writer.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">");
        writer.append("<title>Authentication Error</title>");
        writer.append("</head>");
        writer.append("<body>");
        AlinousSecurityManager.writeErrorInner(writer);
        writer.append("</body>");
        writer.append("</html>");
    }

    public static void writeErrorInner(Writer writer) throws IOException {
        writer.append("<H1>Authentication Error</H1>");
        writer.append("<HR>");
        writer.append("The authentication has failed.<BR><BR><BR><BR>");
        writer.append("<HR>");
        writer.append("Alinous-Core");
    }
}

